# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/CTrilinos clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################


# Include guard
IF (CTrilinos_CONFIG_INCLUDED)
  RETURN()
ENDIF()
SET(CTrilinos_CONFIG_INCLUDED TRUE)

# Make sure CMAKE_CURRENT_LIST_DIR is usable
IF (NOT DEFINED CMAKE_CURRENT_LIST_DIR)
  GET_FILENAME_COMPONENT(_THIS_SCRIPT_PATH ${CMAKE_CURRENT_LIST_FILE} PATH)
  SET(CMAKE_CURRENT_LIST_DIR ${_THIS_SCRIPT_PATH})
ENDIF()


## ---------------------------------------------------------------------------
## Compilers used by Trilinos/CTrilinos build
## ---------------------------------------------------------------------------

SET(CTrilinos_CXX_COMPILER "/usr/bin/mpicxx")

SET(CTrilinos_C_COMPILER "/usr/bin/mpicc")

SET(CTrilinos_FORTRAN_COMPILER "/usr/bin/mpif90")


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/CTrilinos build
## ---------------------------------------------------------------------------

## Set compiler flags, including those determined by build type
SET(CTrilinos_CXX_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -std=c++11 -fopenmp -O3")

SET(CTrilinos_C_FLAGS "  -march=x86-64 -mtune=generic -O2 -pipe -fstack-protector-strong -fno-plt -fopenmp -O3")

SET(CTrilinos_FORTRAN_FLAGS " -O3 -DNDEBUG -O3")

## Extra link flags (e.g., specification of fortran libraries)
SET(CTrilinos_EXTRA_LD_FLAGS "")

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
SET(CTrilinos_SHARED_LIB_RPATH_COMMAND "-Wl,-rpath,/usr/lib")
SET(CTrilinos_BUILD_SHARED_LIBS "ON")

SET(CTrilinos_LINKER /usr/bin/ld)
SET(CTrilinos_AR /usr/bin/ar)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## List of package include dirs
SET(CTrilinos_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../include")

## List of package library paths
SET(CTrilinos_LIBRARY_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../lib")

## List of package libraries
SET(CTrilinos_LIBRARIES "ctrilinos;ifpack;amesos;galeri-xpetra;galeri-epetra;aztecoo;dpliris;xpetra-sup;xpetra;thyratpetra;thyraepetraext;thyraepetra;thyracore;epetraext;tpetraext;tpetrainout;tpetra;kokkostsqr;tpetrakernels;tpetraclassiclinalg;tpetraclassicnodeapi;tpetraclassic;triutils;epetra;rtop;teuchoskokkoscomm;teuchoskokkoscompat;teuchosremainder;teuchosnumerics;teuchoscomm;teuchosparameterlist;teuchoscore;kokkosalgorithms;kokkoscontainers;kokkoscore")

## Specification of directories for TPL headers
SET(CTrilinos_TPL_INCLUDE_DIRS "")

## Specification of directories for TPL libraries
SET(CTrilinos_TPL_LIBRARY_DIRS "")

## List of required TPLs
SET(CTrilinos_TPL_LIBRARIES "/usr/lib/liblapack.so;/usr/lib/libblas.so")

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

SET(CTrilinos_MPI_LIBRARIES "")
SET(CTrilinos_MPI_LIBRARY_DIRS "")
SET(CTrilinos_MPI_INCLUDE_DIRS "")
SET(CTrilinos_MPI_EXEC "/usr/bin/mpiexec")
SET(CTrilinos_MPI_EXEC_MAX_NUMPROCS "4")
SET(CTrilinos_MPI_EXEC_NUMPROCS_FLAG "-np")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

## The packages enabled for this project
SET(CTrilinos_PACKAGE_LIST "CTrilinos;Ifpack;Amesos;Galeri;AztecOO;Pliris;Xpetra;Thyra;ThyraTpetraAdapters;ThyraEpetraExtAdapters;ThyraEpetraAdapters;ThyraCore;EpetraExt;Tpetra;TpetraCore;TpetraTSQR;TpetraKernels;TpetraClassic;Triutils;Epetra;RTOp;Teuchos;TeuchosKokkosComm;TeuchosKokkosCompat;TeuchosRemainder;TeuchosNumerics;TeuchosComm;TeuchosParameterList;TeuchosCore;KokkosAlgorithms;KokkosContainers;KokkosCore")

## The TPLs enabled for this project
SET(CTrilinos_TPL_LIST "LAPACK;BLAS;MPI;Pthread")


# Include configuration of dependent packages
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Ifpack/IfpackConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Amesos/AmesosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Galeri/GaleriConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../AztecOO/AztecOOConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Pliris/PlirisConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Xpetra/XpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Thyra/ThyraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraTpetraAdapters/ThyraTpetraAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraEpetraExtAdapters/ThyraEpetraExtAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraEpetraAdapters/ThyraEpetraAdaptersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../ThyraCore/ThyraCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../EpetraExt/EpetraExtConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Tpetra/TpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraCore/TpetraCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraTSQR/TpetraTSQRConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraKernels/TpetraKernelsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TpetraClassic/TpetraClassicConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Triutils/TriutilsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Epetra/EpetraConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../RTOp/RTOpConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../Teuchos/TeuchosConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosKokkosComm/TeuchosKokkosCommConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosKokkosCompat/TeuchosKokkosCompatConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosRemainder/TeuchosRemainderConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosNumerics/TeuchosNumericsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosComm/TeuchosCommConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosParameterList/TeuchosParameterListConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../TeuchosCore/TeuchosCoreConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosAlgorithms/KokkosAlgorithmsConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosContainers/KokkosContainersConfig.cmake")
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/../KokkosCore/KokkosCoreConfig.cmake")

# Import CTrilinos targets
INCLUDE("${CMAKE_CURRENT_LIST_DIR}/CTrilinosTargets.cmake")
