"use strict";

var _presentation_editor_themes = [];

_presentation_editor_themes[0] = {
    Name: "blank",
    Url: "/theme1/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAAmCAYAAAC1Q9c1AAAEbUlEQVRoQ+2ZWyhtaxTH/8st4UEo5J7InU4oFA8c5JI6Euko16SkJITyQEQcJw+Ua8r1QSfJtSM5SQgnD665JXdyHlzy4LL3Ht9u6ayzlr2W1Zq7PY9vvDHnHHN+vzG+Mf7jW5JPXwzcNEpAwqFqlCdzxqFqnimHKgBTDpVDFYKAAD55TeVQBSAggEu1M/Xy8hKnp6fsk7y8vKClpSXA54nTpdpQY2JiMDo6ylY9MjKC6OhocRIQ4KvVgnp2dgYbGxvo6enh4eGBASWw3L4SUAtqTU0NSkpKkJ+fj9bWVgZ2f38fdnZ2nKu6UJ2dnbGzs4OpqSm0t7djYGAApaWlqKqq4lDVgTo7O4vg4GCYmpri/PwcExMTiI2Nhbm5OY6OjqCrq/sm2OvrawwODmJhYQFXV1fQ0dGBtbU1IiIiQDVaIpH8L4Ly7u2flpaGrq4u5OTkoLm5GU9PT7CysgKpAcrYxMREhWD6+vqQnZ2Nu7s7hdfDwsIwNjb2zaCIhfi7oBIQCwsL3N/fY3FxEf7+/mydBQUFaGhoQEhICGZmZuTWvr6+Dh8fHxYAKhMZGRkssynTu7u7UVlZiZeXF3R2doKCJnZ7F9SOjg5kZmbCzc0NBEpqa2tr8PT0ZH9ubGzA1dVVhktubi6ampqQlJSE/v5+OWbJycns/1lZWazxid3eBTUwMBDz8/Oora1FUVGRzNr9/PywvLyMvLw8NDY2ylw7PDzE5uYmnJyc4OjoKMesuroaZWVlILi9vb1iZ6q6pNra2mIZSJMTZaalpaXM4inDiouLYWxsjJOTExgYGCiE8/z8DIK8t7eH7e1trKysYHx8HBcXF6weU10Wu6mcqZSZdXV1Kq2XykR6errMvQSPMpIAkq6VGnV8MzMzpgY+FFRqMDRBUWNxcXGBoaGhQrh0FkDTlq+vL5aWll7vGRoaQkJCAmtU5CcoKAgeHh7szCAgIIDVUdr+Hwrq8PAw4uLi2JambWpkZKQQ6uTkJCIjI9k1gkpw6XdFmrRIw6ampqKtrY3p039bYWEh6uvrPxZUAkpglTUSkkX29vYMIG1/KgMUBJJhZFSL3d3d5QIibXLx8fFsOBC7Ka2pBIWmHtq6VA+lmfjWwsvLy5nupKymckBZSc2LnlekQ+leeoYsKirq9eRLzGCVQqXmRE2Ksu34+Bja2trfXO/BwQGTTbTtSVqRxEpJSUFPTw/09fWZzqVspZGVai3JMKqxc3Nz8Pb2xurqqph5sm9XCpWEPmlMOpGiqUkVCw0NxfT0NJNgNAzQBEZyq6WlhWWs1GhgqKioQHh4OExMTPD4+AgKiq2trSqv+WHvUQpVk19+c3OD3d1d3N7ewsHBQfTw3mLzXaFqMkA/si8OVYDocKgcqgAEBHApl6m/tm8ofE1Pphv+Kf9J4TWTir9Bh9CKjAYG/PXGiX7IJ/xcMKfwuT9/C0L+H1+ns//a779MCIBCcy45VM2xfPXEoX4PqAK848O55N1fgJBzqByqAAQEcPkZ5j9orWxUdUMAAAAASUVORK5CYII="
};

_presentation_editor_themes[1] = {
    Name: "pixel",
    Url: "/theme2/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[2] = {
    Name: "classic",
    Url: "/theme3/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[3] = {
    Name: "official",
    Url: "/theme4/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[4] = {
    Name: "green",
    Url: "/theme5/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[5] = {
    Name: "lines",
    Url: "/theme6/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[6] = {
    Name: "office",
    Url: "/theme7/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[7] = {
    Name: "safari",
    Url: "/theme8/",
    Thumbnail: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAAmCAYAAAC1Q9c1AAAgAElEQVRoQ917aXRc5ZXtvjXPVVKpSvMsy5YtWxYeMHgAY8DGMQYDJtCdF5I4eTR56W7o1ZAAHWgI8LBJIBAgiY3zaF5CSIAwh8mGGGMbG3mQZU3WPJeqVPM83t7fddr0Wo+13m9SRkiqunXr+853zj777HMkeYeOywajGfmChE/2fhumcAC/e2UUq9c1YXFrJTzBfmh1OqhUebirSzHr9aDEVYRCIQ+d0QRIMrJqPWw2B0z2IuTVWoD3gkqGXm/nlxHZXB5Wvh4JTkEHoH9kBK3tq5BNZ5BLJSCpNbxei1w+izSimA2Pw2Zw4mDvYTRVVWHGMwONbIfRooXDqUORpQSBkBcRfxx2RynXnsXg2AQkTR5efwi5XAG1VaXwTE2Ci4TNbIZKY4JeTqCkzIFwCvB4fSivaEQyUUA244fFYeba1Jj1pGC2m2HUZ2EwWDHjm0SU18QjeXg8c9yPGcEZCYWOIJJ+sUczkjoNfvLKG9CoVNwdTTI31CMf/9V1CMzOwl/QIxYAKqpVMJrsyGRnEYjFsWLFMqiNWUxNzaCo2IHKyhJks6ARcghGE3C7y5CTtahtasD47BysZgv3wo2ozTDpZEyO9sFeUod0NgEND0FrMEFSmTA3O4kidyk6hj7ndydiPh+qKqswHRiHSWNDVX0Nr5nAuHcW2rwK7rISzPq80Gu1sBYXYXR0CqqcDLUqAbW6hEbIwFVRg76+s/DRCCYT11RThgIS8PJgznTOQG3VonVxG4pMJmi1OuUe49OTNHYtGuvLMTUxh2PHjmHFha2Y86lhN7lQ1wAMDw/iREeYn5NH6KM0xsej0Kp1aKajdY3MwCAX4OPe3jpxkkYd75LvvHINqsriXIQF9U0lGBwYx+q1bfjDH0/gosstKCtrgFpD41U18BoDPcRLby1Fgp6Woqel02kaYDESmShSeTVKSkpgtlqQzEgIzXkwNzWEpoWrMO2dQF5SYSwwxNdtsNg1cNlcGPZMQ0YGvWdOYtMVV+LgkV4sXzaPnjbLe9lw6NBRFJfoIRcMGJuJYOvlK7DvyOdY1NiEwaEhbN64GdFYEsM8vFg8BatVh8aWlTRuD+rKqxFJ+DEbCqDUVYmp6TGoJA10ehV0pmJo+bkGgxndZ4dhK3LgZLcHVU4jJsbmcMGS5fDNTCOWmcTImA/brtkG7f4AfvzsJ1jVYsTUpA5pRmE6k4Gbe+6e9eG1Y0dp1OFu+ZlbL2IY5LBwsQ0j/bOobnKhqqYcGlOKRshjaNSLpctboNbrUUgXUKCb5hmxZr0NDt4sl83T+/SIJFPwh2Jobm7B9PQE5i1uRzrOMLIC9z60G8vWulBeXoLn//Aptl/djuIiJ+xmPT0ziLqyCoZhBoFoBAt4QKOTI5j1T2Ll8guwd88xmAyjiERUWLzQjfraeUjLUUxPBXgwFgS8ARSV25HgZ4WDHpRVtyDknYZKZ4ZeY0TPwAyyeT/WX3oxoskYYScPIgRKbCU8aC8MRhH4Knza0YNLLqyH2VzBQ1ahkNNxDX1wOs3wveVD15kgHScFHQ8l6E8iFJBQXuyGZ8IHWAzwzvqxp+NzSN6h0/Lr/3sz1DLgqCxGqcWJUGQAJaUWhBNplFe6MOWdg4YhW1pWCZu9GKNDfdBojYSJOviDAVSWV8FYVIJ8JodQyI+CSoMEw+G1o/uRi6UYSouRJgZbpSzOnBlGFfEur1bDoM2hpMiNv/ylC7fcsh0FNX+31aJn6AQOH/4UDQ016B8SHtOMMHHW4XBAI/6ZjBg4O4BFLS0Maw8/Tw2jTouJ8XFUVNVgYmqa2BpBU30FPdIIidGRSGch51NoqmhCKBOCjt4ZS4ThnwsS6gyIRRIIR1OYV1uPUrcdx48NwRePwQAjHGdyePPQIJY1unnoQVTbKnF2bpqHrIbLqUUwCMKkBGdxGe777fOQQlMn5RfvuhLu0lJ0do3g8q81c6F+Jo8ktHodWtoWom9wCEtXXUJDGpDiKcfDYRiNRlgsNp6YB67KGvi8U/RWO6ZVAzh5ysvklkFLcwMGufkNKy+GLxaERIMk4n4k6dk9PdOEgDzKialZHgDzGtrb1oBvBIifMWJ5JDaL4uIKnOw6hn0fd6Om0oC165YgRhyHVMDJzrPYsOZCdHb3orqqGHneQ8s1FlmK4QvNoK9/FGtWrmTe1GJ6cgLVFeWY9s9gXsMKhKI+hLgWi9mG3u4+hCMplNc40FjRDI1GwuGjnyP8do7rimM2mUely0THU2E0EEWTxYLxYJR70cHm0mGS+TBKm+j1Mp58l54anumRX73nevT2D2HTlmUYmx7B4nY3nd/IN0WQozdVN7UxO1tgL7YhQsxyL/gn2eJcxBT/t/0Y6z4iH3vyTukUk2V33zhq5mngnRTRZUVXTxSVbg3K7CV46zMPFteVEAqr8KPfvAApPtcrf/jIdlo5iU+PjqN5gQ019WZ6kRmj41OorauF0dmEnJRB44J2nnAQNSufxgu/Wo3Vmx6TG+su/ps0bso3KBtcTdIPrnKgTC9h5QXLERwdxKmxaaTNRhQVtOiboiebY4xcLaS8lpQxgV/sPybCv0ve95ProLVmoDOrCcomZtFh8ko7DCYNbCVuOCsXIMuElUim8aehLjx4+wBu+b4Ld/zPD5ltJ+WLL9osqf7K0f4WfNc3clp21S9RnOWn365GhnmhbcF80rQgJobnEC0wyxFSOvv9aK4woaW6CN4w0DucxiMvfwAp5umW333wehz5vB/f+vZazJECjU94sHBVBQHKohDgwXAaR+ihl6xsRSzswdc3f4JlK0tw4nO/YsOXX94rX7ZhDRMCcyaNWyiQFJMQJ1OkK2QMKpWEfD5PrNIgTwoiSRKza0FJIGomtWyORUA2B4OOmJ1JIBJNkxlYeI3Ef8RbJjXIknLvvJwntRIMW7wmK/dNpbKw22zI5LJQ0xQScT8UTsDCokVcKtbDK8mTuQYWGgWZ4Mv/1PyfzLWpuA6jwYBsIoEUny+tbz0ffX/64Qom4BhOnZ3GhC+DWreEFNPXqZ4gZpj9Vy/Tk6mkYddZyesTePy145AS/j75zXu3QW2ZgZkA7GBikEmm/QR6lbsV+1iV1NbXorZSj94RDxZVGrGy/RVm8EpChgHJZBKbNl2GV159Ti7QYLlcjrsi3WIBEItFaVwtCTOrLD6SqaRiJo1WQyNmufEUXMy0wtAyT1/PA8jxZ61WzWtJXUjyxe+yMCSTRYLGM4vNp3NQ875JRo5wGh0tqeJXhoWAifRI4pNpWl4Y3MB7iPtmmP3T2YxyoCk+rxaLpHEZYqRdpEixNDmzUflsk7vpvFF3/T1zidGNuaQPRUXzECD905HdHjk9gDYyBTkZRMGqRpBVVzCSw0MvHCam+ofldx5eidYL5mNsdAQVjQ0YSDnxYfcIAuR87avmsyIaw6JFSxCPTiKe1sEQ34a7774bd9xxB3bv3q0YtqPjfbmRFEh4l5qepdGokeLz4rtEyiMMdM5Bzm02ztcM9CThZTa7jZQpDG1SvBvcNK+jYUw6vZLlkxleQxyTaZACn8+JNE9Di0c6zzKTlZ2J5WiG3s5YAJGOhmLE8Huer/Fq4diKx2pF1PAJflMMXOAval6bpNENNKiZpbfR3XDeqPdsLcccK7rvb70au15/C211FfDO+FFeUosAnSTIr/k1xeganGZi1+KRPxyANDXeL5/61Qbk9QWkHFV46RjrWzOgYZ3NShMJcrl40A8by9P1l7biTM843tijwsDAAPbt24fnnnsOL730Ev759u/hwQfuknMMZa1WVD/0lkyanmpQDFuQ6V2s78UmhSunyAu1JNF5snBRZcnC4gWGoV6NeIrvEzBCONHptYKG815ZWO0OridOGCBk8N55eqYwlJmFR46fF2fxYCPVi/H9Rp0aWnpgjkaPs+LT8X4aHmJS/Mw7Ct5s4vtShCiJ6GLUaHkdqzGTGZayeeeN+tANJXQmFUPeiEB4BtUuI4uTRRhjcXL6bAF1jQaMDAveWyDXlfD4m59A6u45KUf234kfvtSBgl6DaDyE5kUVMLu0tDxpQ4UTFe5ipSrqovcWYio89/gkvUtL4pzAe++9h6uvvpr1fwnOnj0sn9sIhQEaToSdTG4nhBOCJUs9L/bv/wifdZyUhGcK96mpqsD6dWvkK9avhpW8N5VOKu8VXhSJJ2lU8lYazGw20KOUoKXny8hlZL4eI4ZqGBk8FBpXiDzCf9V0Q73AUx6YwPk811AQh8k3G0Xll6CJGDkSr0vzAIQQkqbHCpjR8oBdDYvPG/XZbzYrPNfmtuCjwz28Jo2Nq1bivUMnQfRDSkAO11XkrobPN4V7f0VPHR3rk2+5cQ205gKKq2wUSvK4iHV/LBeAj1XD0qUtNK4P1qJSOO0GPHLPfnx+MIT1l7vw0YdeBUMrKstJ/ufw/PNPylu2XMFkIMLPgKg/RsOqFUz9vy++gjvvfVCKxUncv+Rx2SWr8cKeX8gOUjmBfWaWfWqNTrl/Pp/h5nOK+mQVr9Nr1cTQFENPQ6MW6GoGJsY8DzOfZRlNpxdBb+KByExwwsgiQvLC8AJHeb2asCLw2B+hCGMj5hKS8iJaVAWU1badN+q+e9ZBnxY03YlgwINRRq7bVsRoyLDS9NFjPSyHNazK9Giub8KV//QspOHRbvl7N68HDFwGQ8VZUQZnKdDTP0YyyyRglXHzzdtxdoRq0cAB7H2MCYH1/x13u/H4I7OKeX7wjzvwzNO/wZrVK/Ha7/aKVdMAwkPyrLwMrFh6cenm7ZIw0D9//7v4+g3XyA01VRgiD37nz+9Ljz7+jIKVP9/1E/nqLVso+6mYMB2IMxtnmNDsxNwsE5dIKiKLp5IZeomAGJkHqKY0x5CmFiEcQs1rxJeAnQjfL7BcHIqo5YWlhFEzfJ+B7xPG1zPsEzSQjlWUxAQq7FpcOf+8UT/44cUYnBjDJa0X46WuDpQYeH2CbGBwBs1lVNYYzZJGj0lqAcNjObx4kCrVyDA99fqNdN0wy026cZEevmAOl2yuxfDIJJNDhtlajTJWDMM9frz+21ksXLgQO39Rjy2Xva0Y9eAHb8jrNl6rLOT4gXeYsBqUDYiTz9ED7n3gUWnP87/DdVdvwrO/eEw2CIigAXTiO71ux+13Sa+99S5uuvE6/OyRH8smA+t1mkFLSyWY0Iys9QuFHKXbAvGZyhDhRMc1pZI5ltJaQlaKiUqEM32DiSYQjBFPRUIs8DOoQ/EwjQYdokyKAmMF7kZ4SMWU/wQ2p3mg5AxkFDpeTx2htPG8Ufd+a55ymMlsGq2lNUgZ1Og43gOrs5iUKowjPV4sme+m9JlltZXCrj8x+w+d7ZS3XrYM0SjFAZdQmhJYsryap5gFD0DZTNvSavz5lU4EkjriZgw7d+6EObMH/+vfBhSjeoa75Ku23SydOt2NHd/6e3rwj+WM2Dg3JNJSKBjGydNnKAqXYsmiBYwIGlvQL95bhO/Pn9mNB3c9IV2/dTP+zy9/KufoQoxi0h5BsulNNPJcIIYi4ng8kWUGJ7YKFiC0cBrBxteD0RhsFEZEFhd8NS0EIqOe18mICqMq3qtDhslM9Ve+LJQpwUYEm1DTUwWTcJJW6l3154367t1r4PfTeL09WEAKNR6IY13LEhyg1+rzTGpUyfo9I9iR0cPloEb79IeQBs+eka+4aDHKSnnCgRwWL6WoS7wJ8xRKKQpnNCnULSjGb58cgYcih/i07p4e7L51A+5/s0cx6uxoj/xHKt/3PbxLsttYLJw5JgtcJTzRW8WiiWfENSZZJow8JohDg8MjGB0bw+cnu6VDhw5TfJ7DNV/biN1PPSrr6Un+YBI26qICJ00mMkOGpsSEk2Do6+itKkJMKBpnFBFqqI6JZoOWxN7I8MzT+zPiM2k0K2FCdB7S/Fwh3JjJHGRRTBBWUoIb8+CFMW28TujDIkG66xaeN+q2JRpsbauEtawGZ7pPYnHzCtppBqcCsxjqC+G+lgU4+vEg5lGD9QYSuLLjDKSB/tPyLdvWKqKtZybJJNVE8KUiX0LyznBZvaoVfcNncPSDAIZ8Iqv//x9P7Lxfvnn7DcRT8lASdOEJPX19eOrZ56R9Hx9UiP1/PcQmiikO+0mqt27eiOef/RmhkqSdUqM4jDS5p4olsoGkX1Rdaqrt4vkCfxasliyM+MjiQtAyPh9gmKp5mEXUaUUlJnRTQdtE8rPxnrG0oGQMdn6G2I2gWgJI07zGTAPnpRyKa76oqH72jTrMb5mHl985gO+sWQ11uQsffvoZvuUwwE5H6T44RHajImfNUmDRofT3VKn6e47L37lpPTNpGu3tjewz2RSpz0gdIJGMwjpHHEvY8NaIl7gio9ioRv3CpRjrOYHahRcotsmQBgky7aHyPcuM2L6kFQfe+5Ms+J9MF3rtjXew4wf/qiSqKspvF61chuZ5jXLrwmY0UtB+4/U38fBjP5eu3bIJe5/+qazTkgLR2yz0HsFvBS5LEr2VESQzTAtkAiKTqxnGGmIp3V/hqITYc1WeqJzohRlmfjOxV8iU4Xica6Hv8hB1LCpSQmjnPQS1EnzaQqgQiUtNb7eUfVFRvXgbix4K2yXFepwaGsXWSBpW3tNeWo25oWnlUPMZNSEihwQPpu19lqnDI33yTZsuJGWyQmuMoLq2AkePjOHiFjfUPvZ2vFGMEMc6plg303IV1AzHEjJuv9SJn//lXO0/Odgpi1A/fPQotn/zViV03n/jJbl9yUL+JKF99RXS1LQHN163FU8++u+yQQjHrGLy3IydYX3ngzulJ3b/B27YshEv731SKe0TCdIlLl5P9pCk1qlnQhI8UtFbaXCFr4rnaMgC7yM+R8PQz5CyqehxAi0VzYDX8AqkYhlCGT+Th6wRdEzcg94t9iS8VOgAGr4ucNZW3XI+/If+hxPVC1rgY77IpdWEswzF6FJ4J6bhC9AmxG85w2Ygi5LmBW7gifdoVGLqP3zjUmZ+K1sqKbKAAMojwExExqLmIjhNavz2mBdjoRwa3Hr8w4VVuPPNQfzoSise/SCqGDUw0iP2RgyV0bb2cml6xoO/u/Fa/PqpXfIsG4pNbWuVRR7d/5q8nMxBEPJckpsiHgpeufqam6XjXPT1ZAe/e3qnLJJLkuSe+Ujhq6KjkBf4RwPnmIgE/RIFr0R8LLCCEzdXVDIa6ZxwQ5PSoCpeJ7xROQA+RxMq71PKZSG+MHEJ9iEEFdEVVooF/qip/YL8B26rFakMwTk/HHp2N2KCOzMqKaBL7IvNhh2QU9Q4iDlOtwuO/xCJqveUfPutV2AFOeb7v9wHKati6eVgC1go9aytqRV+HIkqobGllc26fBK/78ng39Y78NDHIcWoMwNdco64J2Lh6Wd/Le168lkKG0Yc+fR9uYgbabhwnRL6e3Y9IH/nxm2KWqRjhZRlv+exX76A+3Y+oRh90/q1eHX3M3IoxgXaBdRJTDLEOpuZm08q4a7wc/qyoFPCk7UibJnMVFSO0gkeMg9KQ2PnGOoi24s6n2CssA22v9iwJCNg+GeUcpeGp6cKDStLrio0gBwP2di09LynTn23HhMeHzJeNj5NMpouWI0oIS4VD+PoURqWcBIl1SiyEL+517b3OiD1dnbKP7p9IzxHIwwfFbuqLgyOj5C+6MnLHPhkJoYTM3ECOrC1WcVGlx5PHUrg/s1uPPBn7zlPHe1T3EF8wMT4KJauu0oStfzj990l3/bNm7Hjzh9LL772tiIDfpNGXTK/QfaRXbzz0QGp49QZXLRsKY4cP4U20q3P335ZzipJSEQ6g1JYhfcV3/RiEbyvSswJiPKTlEyEiPgsoS9EomQKRl77V2lQhLaGGJsXpa9wQVFp8XAFDdMIWODvKWqlineSrZz7nAIMdV9UVG9fbEOlKo55nIHIZFSYHQ8wYuzwjHvZiuG9hQRJjxPeGw4l0PjmCZapvZ3y9pWrmYAM9EbW2maCPwcJrLT6CA06UGALgXi0lFrAJc1aFIpNeOpNH35503zc9lK/YtSRvk5FfyonPoq8seGmHdJfjhzD/MZ6HH/3NTlNoeIeeuPel149Jw3+9bFo/jzcddv35euv2QDnguWSMObw0Q/lylK3ErY6epoSqvS6LMNUT68Usp/CLTPEQdpWeDPTFw9My2vEvYUGIJGCCa87p2SpBL2jzYQiJQynpoeL67IZcmXKEloq+6JmVRQ2eqvuv4X/8BYNhgaBMc5ErK8T1VoGo141qiisdI8DVZYs+iMF1NuoctnLUPzMnyGN9XXJ65euhEWIDbyh1Rxnn78eIZ+HxNyAsoo8LJwbORnMY31tGRLGPB5+cxrfWaXFbz47R7GyI12iwlUWpmYiUWu5aWZosQFZlJbM2oLHx0lnBjhJ4pmOsSlYgbrqciVExeYKBXolk4AQkZWEdE5CVgwlDMvIPydZ02ACXw2MKhU/K0vVSahVRnJZYXihWvEMFF1UhLzA1zyNeU7DJSVTQpzQQLonfhdsQMO6PU2PFdWWjj9rK75IVPFHLsHsZ4cw3KfBvPlWxDnXkGPop8MG6B0Ca5MYCUmYV0T4IUQ1vE5PHTjTJW+8YAVs3IBgj/VuK8rcJja6JilIGFFTx4vJ//RaDgxQE0xr0njqQAQ3rzHh958mkB3tkrV1XwD7eTf8Cv+QHzspq2vbFVwd2m7G7ESCRYUTmnyMCbDAwQ0ZfRknytSs7qgvKBIklTOtwYL5f6RKdbarS9524Sq2X5k8cioq/E5Mzk2ipakSsaSfXqIjd5WpftObyBs31zTiaxxuGLrchNqnP5Y1Cy48D+pfYTv+P0tP9h6UjS1rpanvlSMVTJPWxamUETRUOTTW1WN0ZIqtckZkTgODOYvbOnS4lYxq4/4j54z6jfblFGeNDHLR4yGIsy1d4OBDVY2NocGQkjWsFuyY7xvBFvJY3b/8Xra0r/ubNOZ/t26i61P5ubXrpGvWWpncDJw3i7CIYFEiqs1ghHNadTjSOYH2llp8wFkHDRWrjUdPi0TVI69pW4Jy0otjHNv5qjwiPbdBnzTg6O3PIBKW4DAT+6kgxYnLeorKWSYWh10Q/DylQzcz8xymJySYHIKs61BVa1ZE9mLW7GEqdARhagwqqvxZfvE6k8TJkxzm1xWhf4AjKHSsCX+aXVUbqzcJncMx1JeqcXYsizoK2EWkfZ2TcVz18SFKf9098oa2VlRQ2j8YDeGHG2xfated+yPYe/31X/rajldfxczDjV/6Wvm9Q3j41qu+9LV7f/0uvrur7ktfe+6uUdz1wCNf+tqu++/BxKHtnCwsVqonDeVJ0TGw2ziS9C8vIscMPeOJoKbCzuQRweS4hhM4giVkEfRoOCrJZCQ6v2oTkhwYsbJxF6ZQk+Y8mWgdlJQ7GamclfJQB2BWDyWN1BPYGRYsjGKOh1VbdZkZ43OkZAHKjgssqP56BTVgJxxL90A6031K3t62AkaG/XFmr6+KUcc/uVphCW5XGTpPHoervAJOziiISmmUM1VLmi/G+3/3M0XhyvM5m42cktldNPbiLGYiMTIBGsk3o+HIUI4jokZ2D0zISAmcOhFnx6OEmkExs/6AMjI5xaaenYeRiYSgt3Lij9XU2p2Xc5bKhtNHj1HTKKN6xhLkgr2QJompVyxfgQKf6KO091Ux6tQBtm04ZCYKAY0QflnpCa1UVEoGu4uMRaJ0yNYF6ZQ2q0PHXXuQZVgbdHkq/xKnSggLDNlUKoIiBzUDlr9qjjYZrfRiDsoNjsTYyKN36jheWi1hjBm/5f7LlMHiRNCr9MW0PISIX8x7OSDlUoiyoKm48i1Ige4zctvSdlJ9FYZZNn5VHpnOazmBF6fNJCpqRZwimaMukFF0Ab2F0zW2UvaOjBx3ZKdTVGa8TmJbJeLnUDIFkRwVN7vRgWTPWXz2wSmOhUqwNi9A9RIaiB1VHZuQahYQYX9QmQIXbfBsMoR0NEwYUGF6ZIgKmVHpxrqLaNwAB+9iWTTesJ/k/9RJee0q6oSsdK6l9Q1qI+pUScRYdPBQcUGNHVORCFrnGTHDSRWh1McYCjnKUoPsy5SrDMqQbCgdYbmXZc1uwaInb2BbI48pzxSFYdbnfH64pxP19fUodpF30LvSnPowcuJOlDRiUDhGA9VxaCPsm1C6DRpy5ALXlEwGKLpkUFq7CF4OD7OGVfpeGiMFIBpRb7EyCUVYzmYZylP0TiuHd12U9ui1rOMdNk51c442EYvxszj8HiaGEjKEkbX0cFGs5NhzEoMZotx1uVw0Xlxps0T5nvKaZgVmRvpPE0Js/LJz9nWSLEkYnJM4Uggmi4MDxpPcUw5Lv0ueOtPdLX/j8itR54sgUOAHS0bczN7NFEvWJpeEcd58WakTPWwvL2qyshfDS3TEKNmAfj+lsDQTBQLsnXOI68H1sDQUcywxwB69k9PIw5TJXEwEnG6hSN26sIljRT6lpheeoqPo0tnRi9r5FUwk1RgZ6KFaVs3WBw9kfEBRnmw2zuqzXeLlWHp1VTWNEuL9E5wo4dzripWYnZ0h1hVzODeoTG1r6EXVVawIYyTs1BrYdeeChYYgtCYdzNwbBTKWtRyR5/NGjpsLbVUIBrN0AjEIYuRE+SSbfW1L2tmBCLL97ubcbQiJaJSjRPybha5TyvuLiuyYmQ7QQ5Mc6qvEid4w1u14n9n/dKeiMDk4ypKiGPvephvRlQljbakBxwnm5jj/YIActpStZivr5yr+7cQMNVUzF2+wcaKDik/HaARXPHQJe/Nm4hrHdShYyPT6LIXv6bERNCxo5pSHH1FyO7FA0SJJcsxmiAR6YWsVPUMMNkgM5xiKOT8wNHCW3ujg8K2NXkrOLDoA9Fq29mBlH6i3ewALWhfTu1la0rsK2RQc7LuH2OJwOktY2TAp5bQIcXZWzFjJxNswVS2nwwnP5BC143J6rp/3PjdaXsnh5TjvNTszzj+oKOagR4bled5fb9oAAAAvSURBVInixWLuVKVmu5zJikNanOzzKU1Gk5Z/zBEeQZQj+etueBsZ/g2DeIhD+U9HzLMEVGr6sAAAAABJRU5ErkJggg=="
};

_presentation_editor_themes[8] = {
    Name: "dotted",
    Url: "/theme9/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[9] = {
    Name: "corner",
    Url: "/theme10/",
    Thumbnail: "data:image/png;base64,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"
};

_presentation_editor_themes[10] = {
    Name: "turtle",
    Url: "/theme11/",
    Thumbnail: "data:image/png;base64,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"
};