#!/usr/bin/env python

# Copyright (c) 2013. The EFIDIR team. All right reserved.
#
# This file is part of EFIDIR tools.
#
# EFIDIR tool(s) is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# EFIDIR tool(s) is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public licence
# along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
#
# author: Flavien Vernier / LISTIC
#

import glob
import os
import sys

def listFileNameDiff(a, b):
    c=[]
    for fileName in b:
        c.append(os.path.basename(fileName).rstrip("\n"))
    c = set(c)
    return [aa for aa in a if os.path.basename(aa) not in c]

def genListImage(directory, extention, listName):
    fileNames = []
    # Selects the directory to work with
    os.walk(directory)
    # Scans for files using the glob module with the following rules, anyfilename with the ".extention" extension

    for name in glob.glob(directory+"/*"+extention):
        fileNames.append(name)

    fileNames.sort()

    try:
        f = open(directory+"/"+listName, "r")
        oldFileNames=[]
        for name in f:
            oldFileNames.append(name.rstrip("\n"))
        f.close()
        
        oldFileNames.sort()

        d1 = listFileNameDiff(oldFileNames, fileNames)
        d2 = listFileNameDiff(fileNames, oldFileNames)


        if len(d1)!=0 or len(d2)!=0:
           
            f = open(directory+"/"+listName, "w")
            for name in fileNames:
                f.write(os.path.basename(name))
                f.write("\n")
            f.close()

    except IOError:

        f = open(directory+"/"+listName, "w")
        for name in fileNames:
            f.write(os.path.basename(name))
            f.write("\n")
        f.close()

    return fileNames

