/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef SLT_TRANSFORM_LUT_UTM_H
#define SLT_TRANSFORM_LUT_UTM_H

#include "efidir_image.h"
#include "efidir_param.h"
#include <stdlib.h> 
#include "efidir_latlon2utm.h"

/**
 * \ingroup sarlut_operators
 * \defgroup transform_lut_utm Transform the lut (LAT/LON) to UTM (In phase of development)
 */

/**
 * \ingroup transform_lut_utm
 * \typedef Transform_lut_utm_param
 * \author Yajing YAN (LISTIC)
 *
 * \brief reference on transform_lut_utm_param structure
 *
 */
/**
 * \ingroup transform_lut_utm
 * \struct transform_lut_utm_param
 *
 * \brief structure that contains the parameters of the operator transform_lut_utm
 *
 */
typedef struct struct_transform_lut_utm_param{
  int type; /*!< processing type */
  double ref; /*!< reference longitude */
  int hemis; /*!< hemisphere of site of intest */
}transform_lut_utm_param, *Transform_lut_utm_param;
/**
 * \ingroup transform_lut_utm
 * \fn new_transform_lut_utm_param()
 *
 * \return A new reference on allocated transform_lut_utm_param structure
 *
 * \brief Create a new Transform_lut_utm_param reference 
 *
 */
static Transform_lut_utm_param new_transform_lut_utm_param();
/**
 * \ingroup transform_lut_utm
 * \fn free_transform_lut_utm_param(Transform_lut_utm_param p)
 *
 * \param p A reference on a transform_lut_utm_param structure
 *
 * \brief Free an allocated Transform_lut_utm_param reference 
 *
 */
static void free_transform_lut_utm_param(Transform_lut_utm_param p);

/**
 * \ingroup transform_lut_utm
 * \fn void define_transform_lut_utm_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_transform_lut_utm_param(char *extra_description);
/**
 * \ingroup transform_lut_utm
 * \fn Transform_lut_utm_param get_transform_lut_utm_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Transform_lut_utm_param that contains the parameters.
 */
Transform_lut_utm_param get_transform_lut_utm_param();

/**
 * \ingroup transform_lut_utm
 * \fn void transform_lut_utm(Transform_lut_utm_param p, EFIDIRImage inputlutX, EFIDIRImage inputlutY, EFIDIRImage outputlutX, EFIDIRImage outputlutY);
 * \brief Transform the lut (LAT/LON) in UTM
 * Function allowing to transform the lut to UTM geometry
 *
 * \param p is the structure of the parameters for the operator
 * \param inputlutX Image of lut in X or longitude
 * \param inputlutY Image of lut in Y or latitude
 * \param outputlutX Image to output in X or Est
 * \param outputlutY Image to output in Y or North
 *
 */
void transform_lut_utm(Transform_lut_utm_param p, EFIDIRImage inputlutX, EFIDIRImage inputlutY, EFIDIRImage outputlutX, EFIDIRImage outputlutY);

#endif
