/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RECAL_FROM_1_POINT_SERIE_H
#define RECAL_FROM_1_POINT_SERIE_H

#include "slt_orbit_calculations.h"
#include "slt_get_SAR_coord_1_point.h"
#include "efidir_image_list.h"
#include "efidir_file.h"
#include "efidir_file_txt.h"

/**
 * \ingroup sarlut_operators
 * \defgroup recal_from_1_point_series Recal a series from one Lat/Lon/Alt point
 */

/**
 * \ingroup recal_from_1_point_serie
 * \file slt_recal_from_1_point_series.h
 * \author Diana Rosu, Flavien Vernier
 * 
 * \brief operator for calculation of SAR coordinate from Lat/Lon/Alt
 * 
 * 
 * Computes the coordinates, line and column, as azimuth and range, of a given point if the coordinates (latitude, longitude and altitude) of a specific point ar provided. There is no need for DEM.
 * 
 */


/*
  Structures
*/
/**
 * \ingroup recal_from_1_point_series
 * \struct recal_from_1_point_series_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
/* typedef struct struct_recal_from_1_point_series_param{ */
/*   int file_type;                /\*!< Type of file: (0->xml TerraSAR-X, 1->GAMMA, 2->xml RADARSAT-2*\/ */
/*   int pol_deg;                  /\*!< The polynomial degree used for polynomial interpolation in orbit emulation process*\/ */
/*   char *input_file;             /\*!< Input file for SAR image*\/ */
/*   double altitude;              /\*!< The altitude of the point on the Earth*\/ */
/*   TLatLong curr_pixel_lat_long; /\*!< The latitude and longitude of the point on the Earth*\/ */
/* }recal_from_1_point_serie_param, *Recal_from_1_point_serie_param; */

typedef get_SAR_coord_1_point_param recal_from_1_point_series_param;
typedef Get_SAR_coord_1_point_param Recal_from_1_point_series_param;

/*
  Function of management of structures
*/
/**
 * \ingroup recal_from_1_point_series
 * \fn Recal_from_1_point_serie_param new_recal_from_1_point_series_param();
 *
 * \return A new reference on allocated recal_from_1_point_serie structure
 *
 * \brief Create a new Recal_from_1_point_serie_param reference 
 *
 */
Recal_from_1_point_series_param new_recal_from_1_point_series_param();

/**
 * \ingroup recal_from_1_point_series
 * \fn void free_recal_from_1_point_series_param(Recal_from_1_point_series_param p);
 *
 * \param p A reference on a recal_from_1_point_series structure
 *
 * \brief Free an allocated Recal_from_1_point_series_param reference
 *
 */
void free_recal_from_1_point_series_param(Recal_from_1_point_series_param p);

/*
  Function of management of parameters
*/
/**
 * \ingroup recal_from_1_point_series
 * \fn void define_recal_from_1_point_series_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_recal_from_1_point_series_param(char *extra_description);

/**
 * \ingroup lut
 * \fn  Recal_from_1_point_series_param get_recal_from_1_point_series_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Recal_from_1_point_series_param get_recal_from_1_point_series_param();

/**
 * \ingroup lut
 * \fn void recal_from_1_point_series(Recal_from_1_point_series_param p,  char* xmlFilesName, EFIDIRListImage inputImages);
 * \brief function of allocation of images to output
 *
 * \param p parameters of recal_from_1_point_series
 * \param xmlFilesName xml file of satelite information
 * \param inputImages input list image
 *
 * \return void
 *
 */
void recal_from_1_point_series(Recal_from_1_point_series_param p,  char* xmlFilesName, EFIDIRListImage inputImages);

#endif // RECAL_FROM_1_POINT_SERIE_H
