/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \ingroup sarlut_operators
 * \defgroup parser_tools Some functions used in order to parse the metadata files
 */

/**
 * \ingroup parser_tools
 * \file slt_parser_tools.h
 * \author Diana Rosu
 *
 * \brief Operator for parsing xml files (.xml -> .rsc)
 *
 * file includes (stucture, prototype de fonction) of the operator parsers
 *
 *
 */

#ifndef SLT_PARSERS_H
#define SLT_PARSERS_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "efidir_param.h"
#include "efidir_math.h"
#include "efidir_allocation.h"

/**
* \ingroup parser_tools
* \fn void tsx_xml_2_roi_pac(char *input_file_name, char *data_out_file);
* \brief This function is used in order to extract the state vectors which reside in a .xml file into a new file. The format generated is ROI-PAC compatible.
* \param input_file_name - The xml file that should be parsed
* \param data_out_file - The output file in a ROI-PAC compatible format
*/
void tsx_xml_2_roi_pac(char *input_file_name, char *data_out_file);

/**
* \ingroup parser_tools
* \fn void gamma_output_file_2_roi_pac(char *input_file, char *output_file);
* \brief This function is used in order to generate a ROI-PAC file from an rslc file.
* \param input_file - The rslc file that should be parsed
* \param output_file - The output file in a ROI-PAC compatible format
*/
void gamma_output_file_2_roi_pac(char *input_file, char *output_file);

/**
* \ingroup parser_tools
* \fn int instr(char *string2test, char *pattern);
* \brief This method is used in order to find the position of a pattern in a specified string passed also as a parameter to the function. It returns -1 if the pattern is not included in the input string (string2test).
* \param string2test - The string in which is performed the search
* \param pattern - The string to be searched
* \return an integer which represents the position of the first appearance of the pattern in string2test. If the pattern is not founded then it returns -1
*/
int instr(char *string2test, char *pattern);

/**
* \ingroup parser_tools
* \fn char *get_value_between_2_patterns(char *string2test, char *pattern_start, char *pattern_end);
* \brief This method is used to get any value enclosed between some tags specified as parameters "pattern_start" and "pattern_end". Pay attention the value returned includes an exponent which should be removed using "exponent_remove" method!
* \param string2test - The string in which is performed the search
* \param pattern_start - The string from which we start the copy process
* \param pattern_end - The string from which we finish the copy process
* \return the string enclosed in pattern_start and pattern_end if it terminates without errors, otherwise it returns NULL in string2test. If the pattern is not founded then it returns -1
 */
char *get_value_between_2_patterns(char *string2test, char *pattern_start, char *pattern_end);

/**
* \ingroup parser_tools
* \fn *exponent_remove(char *input_string);
* \brief This method is used to remove the exponent from a string which can appear in the position or velocity strings extracted from the XML file. The parameter that should be provided is a string containing an E with a sign after it
* \param input_string - The string which should be processed
* \return the string without the exponent
*/
char *exponent_remove(char *input_string);

#endif
