/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \ingroup sarlut_operators
 * \defgroup mask_slant Slant geometry mask generation
 */
/**
 * \ingroup mask_slant
 * \file slt_mask_slant.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of generation of mask in radar geometry
 * 
 * file includes (stucture, prototype de fonction) of the operator mask_slant
 * 
 * 
 */

#ifndef SLT_MASK_SLANT_H
#define SLT_MASK_SLANT_H

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"


// typedef struct
// {
// 	float h, rt, hmax; //hmax est l'altitude maximale du MNT initial
// 	double *px;
// 	double beta; // beta est l'angle en radian entre l'axe des Z et (centre de la terre, point courant)
// 	double Xs, Zs;
// 	float alpha_min;
// 	double latA, lonA, latB, lonB;
// 	int inut, verbose;
// 	float romin, romax;  
// 	EFIDIRImageFloat tan_gamma; 
// 	EFIDIRImageFloat tan_theta;
//     float p_sl;
//     char  passe[50];
//     EFIDIRImageFloat theta, thetamp;
//     EFIDIRImageFloat ro, romi, roma, buf, romoins, roplus;
// } simu_aero_t;

/**
 * \ingroup mask_slant
 * \struct valsl
 *
 * \brief structure that contains the parameters of the operator
 *
 */

typedef struct
{
    float *valgr;
    int *valmsq;
    float *rogr;
    float *roci;
    int nrval;
} valsl,*Valsl;

//c'est mal et en double dans slt_intensity_slant (flavien)
static valsl **val_sl;

/**
 * \ingroup mask_slant
 * \fn Simu_param new_mask_slant_param();
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Create a new Simu_param reference 
 *
 */
static Simu_param new_mask_slant_param();

/**
 * \ingroup mask_slant
 * \fn void free_mask_slant_param(Simu_param des);
 *
 * \param des A reference on a simu_param structure
 *
 * \brief Free an allocated Simu_param reference 
 *
 */
void free_mask_slant_param(Simu_param des);

/**
 * \ingroup mask_slant
 * \fn void define_mask_slant_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_mask_slant_param(char *extra_description);

/**
 * \ingroup mask_slant
 * \fn  Simu_param get_mask_slant_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Simu_param get_mask_slant_param();

/**
 * \ingroup mask_slant
 * \fn int mask_slant_init(Simu_param des, EFIDIRImage imMNT, EFIDIRImage immsqgr, EFIDIRImage immsqsl);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param immsqgr is the mask in ground geometry
 * \param immsqsl is the mask in radar geometry
 * \return 0 if no error occurs
 *
 */
int mask_slant_init(Simu_param des, EFIDIRImage imMNT, EFIDIRImage immsqgr, EFIDIRImage immsqsl);

/**
 * \ingroup mask_slant
 * \fn int mask_slant_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte immsqgr, EFIDIRImageByte immsqsl); 
 * \brief function of calculation of mask in radar geometry
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param immsqgr is the mask in ground geometry
 * \param immsqsl is the mask in radar geometry
 * \return 0 if no error occurs
 *
 */

int mask_slant_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte immsqgr, EFIDIRImageByte immsqsl); 

#endif
