/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup sarlut_operators
 * \defgroup generation_lut_radar2ground Generation of LUT (radar->ground)
 */
/**
 * \ingroup generation_lut_radar2ground
 * \file slt_lut_radar_ground.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of generation of LUT (radar->ground)
 * 
 * file includes (stucture, prototype de fonction) of the operator generation_lut_radar2ground
 * 
 * 
 */

#ifndef SLT_LUT_RADAR_GROUND_H
#define SLT_LUT_RADAR_GROUND_H

#include <stdlib.h>
#include <math.h>       /* fonctions mathematiques*/
#include <string.h>       /* fonctions mathematiques*/
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"

/**
 * \ingroup generation_lut_radar2ground
 * \fn Simu_param new_lut_radar_ground_param();
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Create a new Simu_param reference 
 *
 */
Simu_param new_lut_radar_ground_param();

/**
 * \ingroup generation_lut_radar2ground
 * \fn void free_lut_radar_ground_param(Simu_param des);
 *
 * \param des A reference on a simu_param structure
 *
 * \brief Free an allocated Simu_param reference 
 *
 */
void free_lut_radar_ground_param(Simu_param des);

/**
 * \ingroup generation_lut_radar2ground
 * \fn void define_lut_radar_ground_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_lut_radar_ground_param(char *extra_description);

/**
 * \ingroup generation_lut_radar2ground
 * \fn Simu_param get_lut_radar_ground_param();
 * \brief Default efidir function that gets parameters
 *
 *  \return A Simu_param that contains the parameters.
 */
Simu_param get_lut_radar_ground_param();

/**
 * \ingroup generation_lut_radar2ground
 * \fn int lut_radar_ground_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLUTa, EFIDIRImageFloat imLUTr);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imLUTa is the LUT in azimuth
 * \param imLUTr is the LUT in range
 * \return 0 if no error occurs
 *
 */
int lut_radar_ground_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLUTa, EFIDIRImageFloat imLUTr);

/**
 * \ingroup generation_lut_radar2ground
 * \fn int lut_radar_ground_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLUTa, EFIDIRImageFloat imLUTr); 
 * \brief function of calculation of LUT (radar->ground)
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imLUTa is the LUT in azimuth
 * \param imLUTr is the LUT in range
 * \return 0 if no error occurs
 *
 */
int lut_radar_ground_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLUTa, EFIDIRImageFloat imLUTr); 

#endif
