/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \ingroup sarlut_operators
 * \defgroup generation_lut_ground2radar Generation of LUT (ground->radar)
 */
/**
 * \ingroup generation_lut_ground2radar
 * \file slt_lut_ground_radar.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of generation of LUT (ground->radar)
 * 
 * file includes (stucture, prototype de fonction) of the operator generation_lut_ground2radar
 * 
 * 
 */

#ifndef SLT_LUT_GROUND_RADAR_H
#define SLT_LUT_GROUND_RADAR_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"
#include "slt_intensity_ground.h"


// typedef struct
// {
//     char  mask_fold[10]; // rep "N" ou la valeur de remplacement 
//     float v_fold; // valeur de remplacement pour les zones de mask en foldover
//     char  mask_ombre[10]; // rep "N" ou la valeur de remplacement 
//     float v_ombre; // valeur de remplacement pour les zones de mask en  ombre
//     float h, rt;
// //    float px;
//     float p_sl;
//     float thetamin;
//     double latA, lonA, latB, lonB;
//     float romin, romax;  
//     char  passe[10];
//     char  interpol[10];
// //    EFIDIRImageFloat theta;
//     EFIDIRImageFloat ro, romi, roma, buf, buf2;
//     imas4 init, ind;
// } simu_aero_t;

/**
 * \ingroup generation_lut_ground2radar
 * \fn void define_lut_ground_radar_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_lut_ground_radar_param(char *extra_description);

/**
 * \ingroup generation_lut_ground2radar
 * \fn  Simu_param get_lut_ground_radar_param( );
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Simu_param get_lut_ground_radar_param( );

/**
 * \ingroup generation_lut_ground2radar
 * \fn int lut_ground_radar_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imLAT is latitude image (ground geometry)
 * \param imLON is longitude image (ground geometry)
 * \param imLATslant is latitude image (radar geometry)
 * \param imLONslant is longitude image (radar geometry)
 * \return 0 if no error occurs
 *
 */
int lut_ground_radar_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant);

/**
 * \ingroup generation_lut_ground2radar
 * \fn int lut_ground_radar_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant); 
 * \brief function of calculation of LUT
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imMskGr is the mask in ground geometry
 * \param imLAT is latitude image in ground geometry
 * \param imLON is longitude image in ground geometry
 * \param imLATslant is latitude image in radar geometry
 * \param imLONslant is longitude image in radar geometry
 * \return 0 if no error occurs
 *
 */
int lut_ground_radar_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant); 


#endif
