/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup sarlut_operators
 * \defgroup lut Manipulation for calculation of LUT
 */

/**
 * \ingroup lut
 * \file slt_lut.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator for calculation of LUT
 * 
 * file includes (stucture, prototype de fonction) of the operator lut
 * 
 * 
 */

#ifndef SLT_LUT_H
#define SLT_LUT_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"

#define TABSIZE_ANTECEDANTS 100




// typedef struct
// {
//     char  mask_fold[10]; // rep "N" ou la valeur de remplacement 
//     float v_fold; // valeur de remplacement pour les zones de mask en foldover
//     char  mask_ombre[10]; // rep "N" ou la valeur de remplacement 
//     float v_ombre; // valeur de remplacement pour les zones de mask en  ombre
//     float h, rt;
// //    float px;
//     float p_sl;
//     float thetamin;
//     double latA, lonA, latB, lonB;
//     float romin, romax;  
//     char  passe[10];
//     char  interpol[10];
// //    EFIDIRImageFloat theta;
//     EFIDIRImageFloat ro, romi, roma, buf, buf2;
//     imas4 init, ind;
// } simu_aero_t;

/**
 * \ingroup lut
 * \fn Simu_param new_lut_param();
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Create a new Simu_param reference 
 *
 */
static Simu_param new_lut_param();

/**
 * \ingroup lut
 * \fn void free_lut_param(Simu_param des);
 *
 * \param des A reference on a simu_param structure
 *
 * \brief Free an allocated Simu_param reference 
 *
 */
void free_lut_param(Simu_param des);

/**
 * \ingroup lut
 * \fn void define_lut_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_lut_param(char *extra_description);

/**
 * \ingroup lut
 * \fn  Simu_param get_lut_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Simu_param get_lut_param();

/**
 * \ingroup lut
 * \fn int lut_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant, EFIDIRImageFloat imLUTX, EFIDIRImageFloat imLUTY);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imLAT is latitude image in ground geometry
 * \param imLON is longitude image in ground geometry
 * \param imLATslant is latitude image in radar geometry
 * \param imLONslant is longitude image in radar geometry
 * \param imLUTX is X (range) image in radar geometry
 * \param imLUTY is Y (azimuth) image in radar geometry
 * \return 0 if no error occurs
 *
 */
int lut_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant, EFIDIRImageFloat imLUTX, EFIDIRImageFloat imLUTY);

/**
 * \ingroup lut
 * \fn int lut_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant, EFIDIRImageFloat imLUTX, EFIDIRImageFloat imLUTY); 
 * \brief function of calculation of LUT
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imMskGr is the mask in ground geometry
 * \param imLAT is latitude image in ground geometry
 * \param imLON is longitude image in ground geometry
 * \param imLATslant is latitude image in radar geometry
 * \param imLONslant is longitude image in radar geometry
 * \param imLUTX is X (range) image in radar geometry
 * \param imLUTY is Y (azimuth) image in radar geometry
 * \return 0 if no error occurs
 *
 */
int lut_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imLAT, EFIDIRImageFloat imLON, EFIDIRImageFloat imLATslant, EFIDIRImageFloat imLONslant, EFIDIRImageFloat imLUTX, EFIDIRImageFloat imLUTY); 

#endif



