/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup sarlut_operators
 * \defgroup interpol_lut_points_ground2radar Transformation a series of points from ground geometry to radar geometry
 */
/**
 * \ingroup interpol_lut_points_ground2radar
 * \file slt_interpol_lut_points_ground2radar.h
 * \author Yajing Yan
 *
 * \brief operator of transformation of a series of points from ground geometry to radar geometry with LUT (look-up table)
 *
 * file includes (stucture, prototype de fonction) of the operator interpol_lut_points_ground2radar
 *
 *
 */


#ifndef SLT_INTERPOL_LUT_POINTS_GROUND2RADAR_H
#define SLT_INTERPOL_LUT_POINTS_GROUND2RADAR_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_math.h"

/**
 * \ingroup interpol_lut_points_ground2radar
 * \typedef Interpol_lut_points_ground2radar_param
 *
 * \brief reference on interpol_lut_points_ground2radar_param structure
 *
 */
/**
 * \ingroup interpol_lut_points_ground2radar
 * \struct interpol_lut_points_ground2radar_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_interpol_lut_points_ground2radar_param{
  
  int i;
}interpol_lut_points_ground2radar_param, *Interpol_lut_points_ground2radar_param; 

/**
 * \ingroup interpol_lut_points_ground2radar
 * \fn Interpol_lut_points_ground2radar_param new_interpol_lut_points_ground2radar_param()
 *
 * \return A new reference on allocated interpol_lut_points_ground2radar_param structure
 *
 * \brief Create a new Interpol_lut_points_ground2radar_param reference 
 *
 */
static Interpol_lut_points_ground2radar_param new_interpol_lut_points_ground2radar_param();
/**
 * \ingroup interpol_lut_points_ground2radar
 * \fn void free_interpol_lut_points_ground2radar_param(Interpol_lut_points_ground2radar_param p)
 *
 * \param p A reference on a interpol_lut_points_ground2radar_param structure
 *
 * \brief Free an allocated Interpol_lut_points_ground2radar_param reference 
 *
 */
void free_interpol_lut_points_ground2radar_param(Interpol_lut_points_ground2radar_param p);


/**
 * \ingroup interpol_lut_points_ground2radar
 * \fn void define_interpol_lut_points_ground2radar_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_interpol_lut_points_ground2radar_param(char *extra_description);

/**
 * \ingroup interpol_lut_points_ground2radar
 * \fn Interpol_lut_points_ground2radar_param get_interpol_lut_points_ground2radar_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Interpol_lut_points_ground2radar_param that contains the parameters.
 */
Interpol_lut_points_ground2radar_param get_interpol_lut_points_ground2radar_param();

/**
 * \ingroup interpol_lut_points_ground2radar
 * \fn void interpol_lut_points_ground2radar(Interpol_lut_points_ground2radar_param p, EFIDIRImage XImage, EFIDIRImage YImage, char *inputfile, char *outputfile);
 * \brief function of generation of interpol_lut_points_ground2radar
 * Function allowing to transform a series of points from ground geometry to radar geometry
 *
 * \param p is the structure of the parameters for the operator 
 * \param XImage is the lut in X (lut radar to ground)
 * \param YImage is the lut in Y (lut radar to ground)
 * \param inputfile is the input file containing the lat/lon of a series of points
 * \param outputfile is the output file containing the X/Y of the points
 *
 */
void interpol_lut_points_ground2radar(Interpol_lut_points_ground2radar_param p, EFIDIRImage XImage, EFIDIRImage YImage, char *inputfile, char *outputfile);


#endif
