/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \ingroup sarlut_operators
 * \defgroup intensity_slant Slant intensity image simulation
 */
/**
 * \ingroup intensity_slant
 * \file slt_intensity_slant.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of simulation of intensity image in radar geometry
 * 
 * file includes (stucture, prototype de fonction) of the operator intensity_slant
 * 
 * 
 */

#ifndef SLT_INTENSITY_SLANT_H
#define SLT_INTENSITY_SLANT_H


#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"


// typedef struct
// {
//     float h, sr, rt;
//     float p_sl;
//     float theta_min;
//     double latA, lonA, latB, lonB;
//     float romin, romax;  
//     char  passe[50];
//     EFIDIRImageFloat ro, romi, roma, buf, romoins, roplus;
// } intensity_slant_t;
/**
 * \ingroup  intensity_slant
 * \struct valsl
 *
 * \brief structure that contains the parameters of the operator
 *
 */

typedef struct
{
    float *valgr;
    int *valmsq;
    float *rogr;
    float *roci;
    int nrval;
} valsl,*Valsl;

// c'est mal et en double dans slt_mask_slant (flavien)
static valsl **val_sl;

/**
 * \ingroup intensity_slant
 * \fn Simu_param new_intensity_slant_param();
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Create a new Simu_param reference 
 *
 */
static Simu_param new_intensity_slant_param();

/**
 * \ingroup intensity_slant
 * \fn void free_intensity_slant_param(Simu_param des);
 *
 * \param des A reference on a simu_param structure
 *
 * \brief Free an allocated Simu_param reference 
 *
 */
void free_intensity_slant_param(Simu_param des);

/**
 * \ingroup intensity_slant
 * \fn void define_intensity_slant_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_intensity_slant_param(char *extra_description);

/**
 * \ingroup intensity_slant
 * \fn Simu_param get_intensity_slant_param( );
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Simu_param get_intensity_slant_param( );

/**
 * \ingroup intensity_slant
 * \fn int intensity_slant_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imMskSl);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imMskGr is the ground mask
 * \param imMskSl is the slant mask
 * \return 0 if no error occurs
 *
 */
int intensity_slant_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imMskSl);

/**
 * \ingroup intensity_slant
 * \fn int intensity_slant_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imIntens, EFIDIRImageFloat imMskSl); 
 * \brief function of simulation of slant intensity image
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imIntens is the slant intensity image
 * \param imMskSl is the slant mask
 * \return 0 if no error occurs
 *
 */
int intensity_slant_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imIntens, EFIDIRImageFloat imMskSl); 

#endif
