/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup sarlut_operators
 * \defgroup intensity_ground Ground intensity image simulation 
 */
/**
 * \ingroup intensity_ground
 * \file slt_intensity_ground.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of simulation of intensity image in ground geometry 
 * 
 * file includes (stucture, prototype de fonction) of the operator intensity_ground
 * 
 * 
 */

#ifndef SLT_INTENSITY_GROUND_H
#define SLT_INTENSITY_GROUND_H

#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "efidir_param.h"
#include "efidir_image.h"
#include "slt_simu.h"

#define MXI 32767



// typedef struct
// {
// 	float h;
// 	float py; // pas en azimut du MNT (metre)
// 	float theta_min;
// 	double *px;		// pas en ground
// 	double latA, lonA, latB, lonB;
// 	int inut;
// 	char  passe[50]; 
// 	EFIDIRImageFloat dzdx, dzdy; 
// 	EFIDIRImageFloat tan_theta;
// 	EFIDIRImageFloat wx, wy;
// } intensgr_aero_t;

/**
 * \ingroup intensity_ground
 * \fn Simu_param new_simu_param();
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Create a new Simu_param reference 
 *
 */

Simu_param new_simu_param();

/**
 * \ingroup intensity_ground
 * \fn void free_simu_param(Simu_param des);
 *
 * \return A new reference on allocated simu_param structure
 *
 * \brief Free an allocated new Simu_param reference 
 *
 */
void free_simu_param(Simu_param des);

/**
 * \ingroup intensity_ground
 * \fn void define_intensity_ground_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_intensity_ground_param(char *extra_description);

/**
 * \ingroup intensity_ground
 * \fn  Simu_param get_intensity_ground_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Simu_param get_intensity_ground_param();

/**
 * \ingroup intensity_ground
 * \fn int intensity_ground_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imIntens);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imIntens is the intensity image
 * \return 0 if no error occurs
 *
 */
int intensity_ground_init(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageFloat imIntens);

/**
 * \ingroup intensity_ground
 * \fn int intensity_ground_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imIntens);
 * \brief function of calculation of ground intensity image
 *
 * \param des is the structure of the parameters for the operator 
 * \param imMNT is the DEM image
 * \param imMskGr is the ground mask
 * \param imIntens is the ground intensity image
 * \return 0 if no error occurs
 *
 */
int intensity_ground_calc(Simu_param des, EFIDIRImageFloat imMNT, EFIDIRImageByte imMskGr, EFIDIRImageFloat imIntens);

#endif
