/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SLT_GET_SAR_COORD_1_POINT_H
#define SLT_GET_SAR_COORD_1_POINT_H

#include "slt_orbit_calculations.h"

/**
 * \ingroup sarlut_operators
 * \defgroup get_SAR_coord_1_point Get SAR coordinate from Lat/Lon/Alt
 */

/**
 * \ingroup get_SAR_coord_1_point
 * \file slt_get_SAR_coord_1_point.h
 * \author Diana Rosu, Flavien Vernier
 * 
 * \brief operator for calculation of SAR coordinate from Lat/Lon/Alt
 * 
 * 
 * Computes the coordinates, line and column, as azimuth and range, of a given point if the coordinates (latitude, longitude and altitude) of a specific point ar provided. There is no need for DEM.
 * 
 */


/*
  Structures
*/
/**
 * \ingroup get_SAR_coord_1_point
 * \struct get_SAR_coord_1_point_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_get_SAR_coord_1_point_param{
  int file_type;                /*!< Type of file: (0->xml TerraSAR-X, 1->GAMMA, 2->xml RADARSAT-2*/
  int pol_deg;                  /*!< The polynomial degree used for polynomial interpolation in orbit emulation process*/
  char *input_file;             /*!< Input file for SAR image*/
  double altitude;              /*!< The altitude of the point on the Earth*/
  TLatLong curr_pixel_lat_long; /*!< The latitude and longitude of the point on the Earth*/
}get_SAR_coord_1_point_param, *Get_SAR_coord_1_point_param;


/*
  Function of management of structures
*/
/**
 * \ingroup get_SAR_coord_1_point
 * \fn Get_SAR_coord_1_point_param new_get_SAR_coord_1_point_param();
 *
 * \return A new reference on allocated get_SAR_coord_1_point structure
 *
 * \brief Create a new Get_SAR_coord_1_point_param reference 
 *
 */
Get_SAR_coord_1_point_param new_get_SAR_coord_1_point_param();

/**
 * \ingroup get_SAR_coord_1_point
 * \fn void free_get_SAR_coord_1_point_param(Get_SAR_coord_1_point_param p);
 *
 * \param p A reference on a get_SAR_coord_1_point structure
 *
 * \brief Free an allocated Get_SAR_coord_1_point_param reference 
 *
 */
void free_get_SAR_coord_1_point_param(Get_SAR_coord_1_point_param p);

/*
  Function of management of parameters
*/
/**
 * \ingroup get_SAR_coord_1_point
 * \fn void define_get_SAR_coord_1_point_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_get_SAR_coord_1_point_param(char *extra_description);

/**
 * \ingroup lut
 * \fn  Get_SAR_coord_1_point_param get_get_SAR_coord_1_point_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Get_SAR_coord_1_point_param get_get_SAR_coord_1_point_param();

/**
 * \ingroup lut
 * \fn void get_SAR_coord_1_point(Get_SAR_coord_1_point_param p, SAR_Coordinates sar_coord);
 * \brief function of allocation of images to output
 *
 * \param p is the structure of the parameters for the operator 
 * \param sar_coord is set to the position in the sar image
 *
 * \return void
 *
 */
void get_SAR_coord_1_point(Get_SAR_coord_1_point_param p, SAR_Coordinates sar_coord);

#endif //SLT_GET_SAR_COORD_1_POINT_H
