/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GEO_CROP_FROM_1_POINT_SERIE_H
#define GEO_CROP_FROM_1_POINT_SERIE_H

#include "slt_orbit_calculations.h"
#include "slt_get_SAR_coord_1_point.h"
#include "slt_recal_from_1_point_series.h"
#include "com_crop_series.h"
#include "efidir_image_list.h"
#include "efidir_file.h"

/**
 * \ingroup sarlut_operators
 * \defgroup geo_crop_from_1_point_series Crop and recal a series from one Lat/Lon/Alt point
 */

/**
 * \ingroup geo_crop_from_1_point_series
 * \file slt_geo_crop_from_1_point_series.h
 * \author Diana Rosu, Flavien Vernier
 * 
 * \brief operator for calculation of SAR coordinate from Lat/Lon/Alt
 * 
 * 
 * Computes the coordinates, line and column, as azimuth and range, of a given point if the coordinates (latitude, longitude and altitude) of a specific point ar provided. There is no need for DEM.
 * 
 */


/*
  Structures
*/
/**
 * \ingroup geo_crop_from_1_point_series
 * \struct geo_crop_from_1_point_series_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_geo_crop_from_1_point_series_param{
  Recal_from_1_point_series_param  recal_param;         /*!< Parameters of recal operator */
  Crop_series_param                crop_param;          /*!< Parameters of crop operator */
}geo_crop_from_1_point_series_param, *Geo_crop_from_1_point_series_param;


/*
  Function of management of structures
*/
/**
 * \ingroup geo_crop_from_1_point_series
 * \fn Geo_crop_from_1_point_series_param new_geo_crop_from_1_point_series_param();
 *
 * \return A new reference on allocated geo_crop_from_1_point_serie structure
 *
 * \brief Create a new Geo_crop_from_1_point_serie_param reference 
 *
 */
Geo_crop_from_1_point_series_param new_geo_crop_from_1_point_series_param();

/**
 * \ingroup geo_crop_from_1_point_series
 * \fn void free_geo_crop_from_1_point_series_param(Geo_crop_from_1_point_series_param p);
 *
 * \param p A reference on a geo_crop_from_1_point_serie structure
 *
 * \brief Free an allocated Geo_crop_from_1_point_serie_param reference 
 *
 */
void free_geo_crop_from_1_point_series_param(Geo_crop_from_1_point_series_param p);

/*
  Function of management of parameters
*/
/**
 * \ingroup geo_crop_from_1_point_series
 * \fn void define_geo_crop_from_1_point_series_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_geo_crop_from_1_point_series_param(char *extra_description);

/**
 * \ingroup geo_crop_from_1_point_series
 * \fn  Geo_crop_from_1_point_series_param get_geo_crop_from_1_point_series_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simu_param that contains the parameters.
 */
Geo_crop_from_1_point_series_param get_geo_crop_from_1_point_series_param();

/**
 * \ingroup geo_crop_from_1_point_series
 * \fn void geo_crop_from_1_point_series(Geo_crop_from_1_point_series_param p,  char* xmlFilesName, EFIDIRListImage inputImages, EFIDIRListImage outputImages);
 * \brief function of allocation of images to output
 *
 * \param p parameters of geo_crop_from_1_point_series
 * \param xmlFilesName xml file name of satelite informations
 * \param inputImages input image
 * \param outputImages output image
 *
 * \return void
 *
 */
void geo_crop_from_1_point_series(Geo_crop_from_1_point_series_param p,  char* xmlFilesName, EFIDIRListImage inputImages, EFIDIRListImage outputImages);

#endif // GEO_CROP_FROM_1_POINT_SERIE_H
