/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup sarlut_operators
 * \defgroup mapfile Generation of mapfiles
 */

/**
 * \ingroup mapfile
 * \file slt_gen_mapfile.h
 * \author Ivan Petillot and Pascal Bellemain
 * 
 * \brief operator of generation of mapfiles
 * 
 * file includes (stucture, prototype de fonction) of the operator gen_mapfile
 * 
 * 
 */

#ifndef SLT_GEN_MAPFILE_H
#define SLT_GEN_MAPFILE_H

#include "slt_simu.h"
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "efidir_param.h"

// #include "geom2D.h"
// #include "calculs_geodesiques.h"

/**
 * \ingroup mapfile
 * \struct gen_mapfile_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct
{
	TMapInfo mapinfo;
	char *nom_mapfile;
} gen_mapfile_param, *Gen_mapfile_param;

/**
 * \ingroup mapfile
 * \fn Gen_mapfile_param new_gen_mapfile_param ( );
 *
 * \return A new reference on allocated gen_mapfile_param structure
 *
 * \brief Create a new Gen_mapfile_param reference 
 *
 */
static Gen_mapfile_param new_gen_mapfile_param ( );

/**
 * \ingroup mapfile
 * \fn void free_gen_mapfile_param(Gen_mapfile_param des);
 *
 * \param des A reference on a gen_mapfile_param structure
 *
 * \brief Free an allocated Gen_mapfile_param reference 
 *
 */
void free_gen_mapfile_param(Gen_mapfile_param des);

/**
 * \ingroup mapfile
 * \fn void define_gen_mapfile_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_gen_mapfile_param(char *extra_description);

/**
 * \ingroup mapfile
 * \fn  Gen_mapfile_param get_gen_mapfile_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Gen_mapfile_param that contains the parameters.
 */
 Gen_mapfile_param get_gen_mapfile_param( );

/**
 * \ingroup mapfile
 * \fn int gen_mapfile_init(gen_mapfile_param des);
 * \brief function of allocation of images to output
 *
 * \param des is the structure of the parameters for the operator 
 * \return 0 if no error occurs
 *
 */

int gen_mapfile_init(Gen_mapfile_param des);

#endif
