/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PCM_PROJECTION_PAULI_H
#define PCM_PROJECTION_PAULI_H
#define int64 long long
#include <stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup pochem_operators
 * \defgroup projection_pauli Creates the Pauli projection of a Polarimetric image
 */
/**
 * \ingroup projection_pauli
 * \typedef Projection_pauli_param
 * \author George-Alexandru ILIE
 *
 * \brief reference on projection_pauli_param structure
 *
 */

/**
 * \ingroup projection_pauli
 * \struct projection_pauli_param
 *
 * \brief structure that contains the parameters of the operator projection_pauli (no parameters)
 *
 */
typedef struct struct_projection_pauli_param{
}projection_pauli_param, *Projection_pauli_param;

/**
 * \ingroup projection_pauli
 * \fn new_projection_pauli_param()
 *
 * \return A new reference on allocated projection_pauli_param structure
 *
 * \brief Create a new Projection_pauli_param reference 
 *
 */
static Projection_pauli_param new_projection_pauli_param();
/**
 * \ingroup projection_pauli
 * \fn free_projection_pauli_param(Projection_pauli_param p)
 *
 * \param p A reference on a projection_pauli_param structure
 *
 * \brief Free an allocated Projection_pauli_param reference 
 *
 */
void free_projection_pauli_param(Projection_pauli_param p);

/**
 * \ingroup projection_pauli
 * \fn void define_projection_pauli_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_projection_pauli_param(char *extra_description);
/**
 * \ingroup projection_pauli
 * \fn Projection_pauli_param get_projection_pauli_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Projection_pauli_param that contains the parameters.
 */
Projection_pauli_param get_projection_pauli_param();

/**
 * \ingroup projection_pauli
 * \fn void projection_pauli(Projection_pauli_param p, EFIDIRImage in_image, EFIDIRImage out_image);
 * \brief Projection_pauli a image
 * The projection_pauli operator creates the Pauli projection for a given PolSAR image.
 *
 * \param p is the structure of the parameters for the operator (no parameters)
 * \param in_image Image to generate the Pauli projection.
 * \param out_image is the generated Pauli projection.
 *
 */
void projection_pauli(Projection_pauli_param p, EFIDIRImage in_image, EFIDIRImage out_image);

#endif
