/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PCM_PROJECTION_LEXIC_H
#define PCM_PROJECTION_LEXIC_H
#define int64 long long
#include <stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup pochem_operators
 * \defgroup projection_lexic Creates the Lexic(ographic) projection of a Polarimetric image
 */
/**
 * \ingroup projection_lexic
 * \typedef Projection_lexic_param
 * \author George-Alexandru ILIE
 *
 * \brief reference on projection_lexic_param structure
 *
 */

/**
 * \ingroup projection_lexic
 * \struct projection_lexic_param
 *
 * \brief structure that contains the parameters of the operator projection_lexic (no parameters)
 *
 */
typedef struct struct_projection_lexic_param{
}projection_lexic_param, *Projection_lexic_param;

/**
 * \ingroup projection_lexic
 * \fn new_projection_lexic_param()
 *
 * \return A new reference on allocated projection_lexic_param structure
 *
 * \brief Create a new Projection_lexic_param reference 
 *
 */
static Projection_lexic_param new_projection_lexic_param();
/**
 * \ingroup projection_lexic
 * \fn free_projection_lexic_param(Projection_lexic_param p)
 *
 * \param p A reference on a projection_lexic_param structure
 *
 * \brief Free an allocated Projection_lexic_param reference 
 *
 */
void free_projection_lexic_param(Projection_lexic_param p);

/**
 * \ingroup projection_lexic
 * \fn void define_projection_lexic_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_projection_lexic_param(char *extra_description);
/**
 * \ingroup projection_lexic
 * \fn Projection_lexic_param get_projection_lexic_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Projection_lexic_param that contains the parameters.
 */
Projection_lexic_param get_projection_lexic_param();

/**
 * \ingroup projection_lexic
 * \fn void projection_lexic(Projection_lexic_param p, EFIDIRImage in_image, EFIDIRImage out_image);
 * \brief Projection_lexic a image
 * The projection_lexic operator creates the Lexic(ographic) projection for a given PolSAR image.
 *
 * \param p is the structure of the parameters for the operator (no parameters)
 * \param in_image Image to generate the Lexic(ographic) projection.
 * \param out_image is the generated Lexic(ographic) projection.
 *
 */
void projection_lexic(Projection_lexic_param p, EFIDIRImage in_image, EFIDIRImage out_image);


#endif
