/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef PCM_HIERARCHICAL_SEGMENTATION_H
#define PCM_HIERARCHICAL_SEGMENTATION_H
#define int64 long long
#include "efidir_param.h"
#include "efidir_image.h"

/**
 * \ingroup pochem_operators
 * \defgroup hierarchical_segmentation Hierarchical segmentation algorithm
 */
/**
 * \ingroup hierarchical_segmentation
 * \typedef Hierarchical_segmentation_param
 * \author George-Alexandru ILIE
 *
 * \brief reference on hierarchical_segmentation_param structure
 *
 */
 
 /**
 * \ingroup hierarchical_segmentation
 * \struct hierarchical_segmentation_param
 *
 * \brief structure that contains the parameters of the operator hierarchical_segmentation
 *
 */
typedef struct struct_hierarchical_segmentation_param{
  char *model; /*!< model of the multivariate probability distribution (e.g. [gaussian] or [kummeru]) */
  long int in_iterations; /*!< number of segmentation iterations */
}hierarchical_segmentation_param, *Hierarchical_segmentation_param;

/**
 * \ingroup hierarchical_segmentation
 * \fn new_hierarchical_segmentation_param()
 *
 * \return A new reference on allocated hierarchical_segmentation_param structure
 *
 * \brief Create a new Hierarchical_segmentation_param reference 
 *
 */
static Hierarchical_segmentation_param new_hierarchical_segmentation_param();
/**
 * \ingroup hierarchical_segmentation
 * \fn free_hierarchical_segmentation_param(Hierarchical_segmentation_param p)
 *
 * \param p A reference on a hierarchical_segmentation_param structure
 *
 * \brief Free an allocated Hierarchical_segmentation_param reference 
 *
 */
void free_hierarchical_segmentation_param(Hierarchical_segmentation_param p);

/**
 * \ingroup hierarchical_segmentation
 * \fn void define_hierarchical_segmentation_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_hierarchical_segmentation_param(char *extra_description);
/**
 * \ingroup hierarchical_segmentation
 * \fn Hierarchical_segmentation_param get_hierarchical_segmentation_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Hierarchical_segmentation_param that contains the parameters.
 */
Hierarchical_segmentation_param get_hierarchical_segmentation_param();

/**
 * \ingroup hierarchical_segmentation
 * \fn void hierarchical_segmentation(Hierarchical_segmentation_param p, EFIDIRImage in_image, EFIDIRImage in_mask, EFIDIRImage out_voisinage, EFIDIRImage out_dissimilarite, EFIDIRImage out_mask);
 * \brief Hierarchical_segmentation a image
 * The hierarchical_segmentation operator makes a segmentation of a given PolSAR image.
 *
 * \param p is the structure of the parameters for the operator
 * \param in_image Image to be segmented.
 * \param in_mask Initial mask (segmentation).
 * \param out_voisinage Final neighborhood matrix.
 * \param out_dissimilarite Final distances matrix.
 * \param out_mask Final mask (segmentation).
 *
 */
void hierarchical_segmentation(Hierarchical_segmentation_param p, EFIDIRImage in_image, EFIDIRImage in_mask, EFIDIRImage out_voisinage, EFIDIRImage out_dissimilarite, EFIDIRImage out_mask);
#endif
