/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef PCM_GRID_MASK_H
#define PCM_GRID_MASK_H
#include <stdlib.h>
#include <math.h>
#define int64 long long
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup pochem_operators
 * \defgroup grid_mask Create a grid segmentation mask
 */
/**
 * \ingroup grid_mask
 * \typedef Grid_mask_param
 * \author George-Alexandru ILIE
 *
 * \brief reference on grid_mask_param structure
 *
 */

/**
 * \ingroup grid_mask
 * \struct grid_mask_param
 *
 * \brief structure that contains the parameters of the operator grid_mask
 *
 */
typedef struct struct_grid_mask_param{
  int rows; /*!< number of rows of a square in the grid */
  int columns; /*!< number of columns of a square in the grid */
}grid_mask_param, *Grid_mask_param;

/**
 * \ingroup grid_mask
 * \fn new_grid_mask_param()
 *
 * \return A new reference on allocated grid_mask_param structure
 *
 * \brief Create a new Grid_mask_param reference 
 *
 */
static Grid_mask_param new_grid_mask_param();
/**
 * \ingroup grid_mask
 * \fn free_grid_mask_param(Grid_mask_param p)
 *
 * \param p A reference on a grid_mask_param structure
 *
 * \brief Free an allocated Grid_mask_param reference 
 *
 */
void free_grid_mask_param(Grid_mask_param p);

/**
 * \ingroup grid_mask
 * \fn void define_grid_mask_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_grid_mask_param(char *extra_description);
/**
 * \ingroup grid_mask
 * \fn Grid_mask_param get_grid_mask_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Grid_mask_param that contains the parameters.
 */
Grid_mask_param get_grid_mask_param();

/**
 * \ingroup grid_mask
 * \fn void grid_mask(Grid_mask_param p, EFIDIRImage in_image, EFIDIRImage output_mask);
 * \brief Grid_mask a image
 * The grid_mask operator creates a grid mask for a given PolSAR image.
 *
 * \param p is the structure of the parameters for the operator
 * \param in_image Image to generate the grid mask.
 * \param output_mask is the generated grid mask.
 *
 */
void grid_mask(Grid_mask_param p, EFIDIRImage in_image, EFIDIRImage output_mask);

#endif
