/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PAM_CONVERT_DWORD_IMAGE_TO_JPEG_H
#define PAM_CONVERT_DWORD_IMAGE_TO_JPEG_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"


/**
 * \ingroup spatpam_operators
 * \defgroup convert_DWORD_IMAGE_to_JPEG convert_DWORD_IMAGE_to_JPEG operator
 */

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \file pam_convert_DWORD_IMAGE_to_JPEG.h
 * \author Nicolas Meger
 * \brief convert_DWORD_IMAGE_to_JPEG operator 
 */

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG 
 * \struct convert_DWORD_IMAGE_to_JPEG_param
 *
 * \brief Structure that contains the parameters of the operator
 *
 */

typedef struct convert_DWORD_IMAGE_to_JPEG_param
{
} convert_DWORD_IMAGE_to_JPEG_param, *Convert_DWORD_IMAGE_to_JPEG_param;

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \fn Convert_DWORD_IMAGE_to_JPEG_param new_convert_DWORD_IMAGE_to_JPEG_param()
 * \brief Create a new convert_DWORD_IMAGE_to_JPEG_param reference
 * 
 * \return A new reference on an allocated convert_DWORD_IMAGE_to_JPEG_param structure
 *
 *
 */

static Convert_DWORD_IMAGE_to_JPEG_param new_convert_DWORD_IMAGE_to_JPEG_param();

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \fn void free_convert_DWORD_IMAGE_to_JPEG_param(Convert_DWORD_IMAGE_to_JPEG_param p)
 *
 * \param p A reference on a convert_DWORD_IMAGE_to_JPEG_param structure
 *
 * \brief Free an allocated convert_DWORD_IMAGE_to_JPEG_param reference 
 *
 */

void free_convert_DWORD_IMAGE_to_JPEG_param(Convert_DWORD_IMAGE_to_JPEG_param p);

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \fn void define_convert_DWORD_IMAGE_to_JPEG_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/

void define_convert_DWORD_IMAGE_to_JPEG_param(char *extra_description);

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \fn convert_DWORD_IMAGE_to_JPEG_param get_convert_DWORD_IMAGE_to_JPEG_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A convert_DWORD_IMAGE_to_JPEG_param that contains the parameters.
 */

Convert_DWORD_IMAGE_to_JPEG_param get_convert_DWORD_IMAGE_to_JPEG_param();

/**
 * \ingroup convert_DWORD_IMAGE_to_JPEG
 * \fn void convert_DWORD_IMAGE_to_JPEG(EFIDIRImage image,  FILE* jpeg_file_pointer);
 * \brief convert_DWORD_IMAGE_to_JPEG operator
 * \param image is the DWORD image that is about to be jpeged.
 * \param jpeg_file_pointer points to the jpeg file to be generated.
 */

void convert_DWORD_IMAGE_to_JPEG(EFIDIRImage image,  FILE* jpeg_file_pointer);

#endif /* PAM_CONVERT_DWORD_IMAGE_TO_JPEG_H */
