/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PAM_SITS_QUANTIZATION_H
#define PAM_SITS_QUANTIZATION_H

//#include "efidir_image.h"
#include "efidir_image_list.h"
#include "efidir_param.h"
#include <stdlib.h>

/**
 * \ingroup spatpam_operators
 * \defgroup SITS_quantization SITS phase differences quantization operator
 */

/**
 * \ingroup SITS_quantization
 * \file pam_SITS_quantization.h
 * \author Andreea Julea and Nicolas Meger
 * \brief SITS phase differences quantization operator 
 */

/**
 * \ingroup SITS_quantization
 * \struct SITS_quantization_param
 *
 * \brief Structure that contains the parameters of the operator
 *
 */

typedef struct SITS_quantization_param
{
  int number_of_intervals;
}sITS_quantization_param, *SITS_quantization_param;

/**
 * \ingroup SITS_quantization
 * \fn SITS_quantization_param new_SITS_quantization_param()
 * \brief Create a new SITS_quantization_param reference
 * 
 * \return A new reference on an allocated SITS_quantization_param structure
 *
 *
 */

static SITS_quantization_param new_SITS_quantization_param();

/**
 * \ingroup SITS_quantization
 * \fn free_SITS_quantization_param(SITS_quantization_param p)
 *
 * \param p A reference on an SITS_quantization_param structure
 *
 * \brief Free an allocated SITS_quantization_param reference 
 *
 */

void free_SITS_quantization_param(SITS_quantization_param p);

/**
 * \ingroup SITS_quantization
 * \fn void define_SITS_quantization_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/

void define_SITS_quantization_param(char *extra_description);

/**
 * \ingroup SITS_quantization
 * \fn SITS_quantization_param get_SITS_quantization_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A SITS_quantization_param that contains the parameters.
 */

SITS_quantization_param get_SITS_quantization_param();

/**
 * \ingroup SITS_quantization
 * \fn void SITS_quantization(SITS_quantization_param p, EFIDIRListImage inputImages, FILE* preprocessed_data_pointer);
 * \brief SITS phase differences quantization operator. The date of the first image is set to 1 and so on.
 * \param p is the structure containing the parameters, i.e. the number of quantization intervals
 * \param inputImages is the SITS of phase differences to be quantized
 * \param preprocessed_data_pointer points to the preprocessed data file containing the quantized values (that file is the main input of SPATPAM and of the patten localization operator)
 *
 */

void SITS_quantization(SITS_quantization_param p, EFIDIRListImage inputImages, FILE* preprocessed_data_pointer);

#endif /* PAM_SITS_QUANTIZATION_H */
