/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef OCV_REGISTRATION_H
#define OCV_REGISTRATION_H

#include <stdio.h>
#include <stdlib.h>

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_opencv.h"

//#include "highgui.h"
#include "opencv2/imgproc/imgproc.hpp"

/**
 * \ingroup opencv
 * \defgroup registration Registrate 2 images
 */

/**
 * \ingroup registration
 * \typedef Registration_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on registration_param structure
 *
 */

/**
 * \ingroup registration
 * \struct registration_param
 *
 * \brief structure that contains the parameters of the operator registration
 *
 */


typedef struct struct_registration_param{
  double *master_POI; /*!< Points of interest (POI) in the master image {x1 y1 x2 y2...} */
  int numberOf_master_coord; /*!< Number of coordinates into the master_POI list */
  double *slave_POI; /*!< Points of interest in the slave image {x1 y1 x2 y2...} */
  int numberOf_slave_coord; /*!< Number of coordinates into the slave_POI list */
  char *master_POI_file_name; /*!< File name of points of interest (POI) in the master image {x1 y1 x2 y2...} */
  char *slave_POI_file_name; /*!< File name of points of interest (POI) in the slave image {x1 y1 x2 y2...} */
  int registration_type; /*!< Regidtration type: 0 affine(default), 1 projectiv */
}registration_param, *Registration_param;


/**
 * \ingroup registration
 * \fn new_registration_param()
 *
 * \return A new reference on allocated registration_param structure
 *
 * \brief Create a new Registration_param reference 
 *
 */
Registration_param new_registration_param();
/**
 * \ingroup registration
 * \fn free_registration_param(Registration_param p)
 *
 * \param p A reference on a registration_param structure
 *
 * \brief Free an allocated Registration_param reference 
 *
 */
void free_registration_param(Registration_param p);

/**
 * \ingroup registration
 * \fn void define_registration_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_registration_param(char *extra_description);
/**
 * \ingroup registration
 * \fn Registration_param get_registration_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Registration_param that contains the parameters.
 */
Registration_param get_registration_param();


/**
 * \ingroup crop
 * \fn void registration(Registration_param p, EFIDIRImage masterImage, EFIDIRImage slaveImage,EFIDIRImage outputImage);
 *
 * \brief Registrate 2 images
 *
 * Registrate 2 images according to points of interest (POI). 
 * Affine or projective method can be used.
 * Affine requires 3 POI and projective method require 4 POI.
 *
 * \param p is the structure of the parameters for the operator
 * \param masterImage first image (master).
 * \param slaveImage second image (slave).
 * \param outputImage registered image.
 */
void registration(Registration_param p, EFIDIRImage masterImage, EFIDIRImage slaveImage,EFIDIRImage outputImage);
#endif
