/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef OCV_PROJECTEDMNT2DEPTH_H
#define OCV_PROJECTEDMNT2DEPTH_H

#include <stdio.h>
#include <stdlib.h>

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_opencv.h"

//#include "highgui.h"
#include "opencv2/imgproc/imgproc.hpp"

/**
 * \ingroup opencv
 * \defgroup projectedMNT2Depth Registrate 2 images
 */

/**
 * \ingroup projectedMNT2Depth
 * \typedef projectedMNT2Depth_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on projectedMNT2Depth_param structure
 *
 */

/**
 * \ingroup projectedMNT2Depth
 * \struct ProjectedMNT2Depth_param
 *
 * \brief structure that contains the parameters of the operator projectedMNT2Depth
 *
 */


typedef struct struct_projectedMNT2Depth_param_param{
  double e; /*!< Est coordinate of the point of view (in same metric unit as MNT) */
  double n; /*!< North coordinate of the point of view (in same metric unit as MNT) */
  double z; /*!< Up coordinate of the point of view (in same metric unit as MNT) */
}projectedMNT2Depth_param, *ProjectedMNT2Depth_param;


/**
 * \ingroup projectedMNT2Depth
 * \fn ProjectedMNT2Depth_param new_projectedMNT2Depth_param()
 *
 * \return A new reference on allocated projectedMNT2Depth_param structure
 *
 * \brief Create a new projectedMNT2Depth_param reference 
 *
 */
ProjectedMNT2Depth_param new_projectedMNT2Depth_param();
/**
 * \ingroup projectedMNT2Depth
 * \fn free_projectedMNT2Depth_param(ProjectedMNT2Depth_param p)
 *
 * \param p A reference on a projectedMNT2Depth_param structure
 *
 * \brief Free an allocated projectedMNT2Depth_param reference 
 *
 */
void free_projectedMNT2Depth_param(ProjectedMNT2Depth_param p);

/**
 * \ingroup projectedMNT2Depth
 * \fn void define_projectedMNT2Depth_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_projectedMNT2Depth_param(char *extra_description);
/**
 * \ingroup projectedMNT2Depth
 * \fn ProjectedMNT2Depth_param get_projectedMNT2Depth_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A projectedMNT2Depth_param that contains the parameters.
 */
ProjectedMNT2Depth_param get_projectedMNT2Depth_param();


/**
 * \ingroup crop
 * \fn void projectedMNT2Depth(ProjectedMNT2Depth_param p, EFIDIRImage projectedMNTImage, EFIDIRImage depthImage);
 *
 * \brief Registrate 2 images
 *
 * Registrate 2 images according to points of interest (POI). 
 * Affine or projective method can be used.
 * Affine requires 3 POI and projective method require 4 POI.
 *
 * \param p is the structure of the parameters for the operator
 * \param masterImage first image (master).
 * \param slaveImage second image (slave).
 * \param outputImage registered image.
 */
void projectedMNT2Depth(ProjectedMNT2Depth_param p, EFIDIRImage projectedMNTImage, EFIDIRImage depthImage);
#endif
