/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef OCV_DISP_PIXEL2METER_H
#define OCV_DISP_PIXEL2METER_H

#include <stdio.h>
#include <stdlib.h>

#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_opencv.h"

//#include "highgui.h"
#include "opencv2/imgproc/imgproc.hpp"

/**
 * \ingroup opencv
 * \defgroup disp_pixel2meters Convert displacement in pixel to meters
 */

/**
 * \ingroup disp_pixel2meters
 * \typedef disp_pixel2meters_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on disp_pixel2meters_param structure
 *
 */

/**
 * \ingroup disp_pixel2meters
 * \struct Disp_pixel2meters_param
 *
 * \brief structure that contains the parameters of the operator disp_pixel2meters
 *
 */


typedef struct struct_disp_pixel2meters_param{
  double f; /*!< Focal of the camera (m)*/
  double pixelSize; /*!< Pixel size of the camera (m) */
}disp_pixel2meters_param, *Disp_pixel2meters_param;


/**
 * \ingroup disp_pixel2meters
 * \fn Disp_pixel2meters_param new_disp_pixel2meters_param()
 *
 * \return A new reference on allocated disp_pixel2meters_param structure
 *
 * \brief Create a new disp_pixel2meters_param reference 
 *
 */
Disp_pixel2meters_param new_disp_pixel2meters_param();
/**
 * \ingroup disp_pixel2meters
 * \fn free_disp_pixel2meters_param(Disp_pixel2meters_param p)
 *
 * \param p A reference on a disp_pixel2meters_param structure
 *
 * \brief Free an allocated disp_pixel2meters_param reference 
 *
 */
void free_disp_pixel2meters_param(Disp_pixel2meters_param p);

/**
 * \ingroup disp_pixel2meters
 * \fn void define_disp_pixel2meters_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_disp_pixel2meters_param(char *extra_description);
/**
 * \ingroup disp_pixel2meters
 * \fn Disp_pixel2meters_param get_disp_pixel2meters_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A disp_pixel2meters_param that contains the parameters.
 */
Disp_pixel2meters_param get_disp_pixel2meters_param();


/**
 * \ingroup crop
 * \fn void disp_pixel2meters(Disp_pixel2meters_param p, EFIDIRImage projectedMNTImage, EFIDIRImage depthImage);
 *
 * \brief Registrate 2 images
 *
 * Registrate 2 images according to points of interest (POI). 
 * Affine or projective method can be used.
 * Affine requires 3 POI and projective method require 4 POI.
 *
 * \param p is the structure of the parameters for the operator
 * \param masterImage first image (master).
 * \param slaveImage second image (slave).
 * \param outputImage registered image.
 */
void disp_pixel2meters(Disp_pixel2meters_param p, EFIDIRImage disp_pixel, EFIDIRImage depth, EFIDIRImage disp_meters);
#endif
