/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup lardis_operators
 * \defgroup shift_sar_accuracy short description
 */

#ifndef LAR_SHIFT_ACCURACY_SAR_H
#define LAR_SHIFT_ACCURACY_SAR_H

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_math.h"
#include "efidir_image_list.h"

#define RANGE_PIXEL_SPACING 1.36410510540008545
#define REGISTRATION_OFFSET 81.0000000000000000
#define PEAK_THRESHOLD 0.85

/**
 * \ingroup shift_sar
 * \file lar_shift_sar_accuracy.h
 * \author Renaud Fallourd (LISTIC)
 *
 * \brief operator of ... 
 *
 * file includes (stucture, prototype de fonction) of the operator shift_sar_accuracy
 *
 *
 */

/**
 * \ingroup shift_sar_accuracy
 * \typedef typedef shift_sar_accuracy_param
 * \struct shift_sar_accuracy_param
 *
 * \brief structure that contains the parameters of the operator nom
 *
 */
typedef struct struct_shift_sar_accuracy_param{
  int maxi_window_nb_r; /*!< row size of window (azimut) */
  int maxi_window_nb_c; /*!< column size of window (range) */
  int maxi_window_search_nb_r; /*!< row size of search window */
  int maxi_window_search_nb_c; /*!< column size of search window */
  int verbose; /*!< Verbose option for debug*/
}shift_sar_accuracy_param, *Shift_sar_accuracy_param;

/**
 * \ingroup shift_sar_accuracy
 * \fn new_shift_sar_accuracy_param()
 *
 * \return A new reference on allocated shift_sar_accuracy_param structure
 *
 * \brief Create a new shift_sar_accuracy_param reference 
 *
 */
static Shift_sar_accuracy_param new_shift_sar_accuracy_param();

/**
 * \ingroup shift_sar_accuracy
 * \fn free_shift_sar_accuracy_param(Shift_sar_accuracy_param p)
 *
 * \param p A reference on a shift_sar_accuracy_param structure
 *
 * \brief Free an allocated Shift_sar_accuracy_param reference 
 *
 */
void free_shift_sar_accuracy_param(Shift_sar_accuracy_param p);

/**
 * \ingroup shift_sar_accuracy
 * \fn void define_shift_sar_accuracy_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_shift_sar_accuracy_param(char *extra_description);

/**
 * \ingroup shift_sar_accuracy
 * \fn Shift_sar_accuracy_param get_shift_sar_accuracy_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Shift_sar_accuracy_param that contains the parameters.
 */
Shift_sar_accuracy_param get_shift_sar_accuracy_param();

/**
 * \ingroup shift_sar_accuracy
 * \fn void shift_sar_accuracy(Shift_sar_accuracy_param p,EFIDIRListImage inputList,EFIDIRImage mask,char *m_file_name,char *proc_sizes_name);
 * \brief ...
 *
 * \param p ...
 * \param inputList ...
 * \param mask ...
 * \param m_file_name ...
 * \param proc_sizes_name ...
 */
void shift_sar_accuracy(Shift_sar_accuracy_param p,EFIDIRListImage inputList,EFIDIRImage mask,char *m_file_name,char *proc_sizes_name);

void shift_sar_accuracy_delux(Shift_sar_accuracy_param p,EFIDIRListImage inputListVec,EFIDIRListImage inputListPeak,EFIDIRListImage inputListPerf,EFIDIRListImage inputListFwhm,EFIDIRImage rangeImg,EFIDIRImage azimuthImg,EFIDIRImage mask,char *m_file_name,char *proc_sizes_name,float peak_step,float perf_max,float perf_step);

static void image_avg_std(Shift_sar_accuracy_param p,EFIDIRImage image,EFIDIRImage mask,float *avg1,float *avg2,float *std1,float *std2,float *perc);

static void find_best_threshold(Shift_sar_accuracy_param p,EFIDIRImage image_vec,EFIDIRImage image_peak,EFIDIRImage image_perf,EFIDIRImage image_range,EFIDIRImage image_azimuth,EFIDIRImage mask,float peak_step,float perf_max,float perf_step,float *avg1,float *avg2,float *std1,float *std2,float *perc,float *peak_threshold,float *perf_threshold);

static void generate_mfile(Shift_sar_accuracy_param p,float *avg1,float *avg2,float *std1,float *std2,float *perc,int dim_tab,int datatype,char *m_file_name,char *proc_sizes_name);

static void display_results(float *avg1,float *avg2,float *std1,float *std2,float *perc,int dim_tab,int datatype);

#endif /* LAR_SHIFT_SAR_ACCURACY_H */
