/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup lardis_operators
 * \defgroup low_pass_filter low pass filter : image which mapped where the displacement measurement is possible
 */
#ifndef LAR_LOW_PASS_FILTER_H
#define LAR_LOW_PASS_FILTER_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include "efidir_image_list.h"


/**
 * \ingroup low_pass_filter
 * \typedef Low_pass_filter_param
 *
 * \brief reference on low_pass_filter_param structure
 *
 */
/**
 * \ingroup low_pass_filter
 * \struct low_pass_filter_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */

typedef struct struct_low_pass_filter_param{
  int window_nb_lines; /*!< lines number of the median filter window */
  int window_nb_columns; /*!< columns number of the median filter window */
  int verbose; /*!< Verbose option for debug*/
}low_pass_filter_param, *Low_pass_filter_param;

/**
 * \ingroup low_pass_filter
 * \fn new_low_pass_filter_param()
 *
 * \return A new reference on allocated low_pass_filter_param structure
 *
 * \brief Create a new Low_pass_filter_param reference 
 *
 */
static Low_pass_filter_param new_low_pass_filter_param();

/**
 * \ingroup low_pass_filter
 * \fn free_low_pass_filter_param(Low_pass_filter_param p)
 *
 * \param p A reference on a low_pass_filter_param structure
 *
 * \brief Free an allocated Low_pass_filter_param reference 
 *
 */
void free_low_pass_filter_param(Low_pass_filter_param p);

/**
 * \ingroup low_pass_filter
 * \fn void define_low_pass_filter_param(char *extra_description)
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_low_pass_filter_param(char *extra_description);

/**
 * \ingroup low_pass_filter
 * \fn Low_pass_filter_param get_low_pass_filter_param()
 * \brief Default efidir function that gets parameters
 *
 * \return A Low_pass_filter_param that contains the parameters.
 */
Low_pass_filter_param get_low_pass_filter_param();

/**
 * \ingroup low_pass_filter
 * \fn void low_pass_filter(Low_pass_filter_param p,EFIDIRImage inputImage,EFIDIRImage maskImage,EFIDIRImage outputImage);
 * \brief function of image co-registration
 * Function allowing to mapped where the displacement measurement is possible
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the image input
 * \param maskImage is the mask input image
 * \param outputImage is the filtered output image
 *
 */
void low_pass_filter(Low_pass_filter_param p,EFIDIRImage inputImage,EFIDIRImage maskImage,EFIDIRImage outputImage);

void low_pass_filter_float(Low_pass_filter_param p,int ibcl,int jbcl,EFIDIRImage inputImage,EFIDIRImage maskImage,EFIDIRImage outputImage);

#endif /* LAR_LOW_FILTER_FILTER_H */
