/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup 3D_inversion
 * \defgroup inversion_3d_dpl mdiff surfdisp: Surface 3D displacement estimation
 */
/**
 * \ingroup inversion_3d_dpl
 * \file lar_inversion_3d_dpl.h
 * \author Yajing Yan ("surfdisp" modified by Renaud Fallourd)
 * 
 * \brief operator of calculating the surface displacement in a (E,N,U) framework from the displacements of different projections
 * 
 * file includes (stucture, prototype de fonction) of the operator inversion_3d_dpl
 * 
 * 
 */

#ifndef LAR_INVERSION_3D_DPL_H
#define LAR_INVERSION_3D_DPL_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include "efidir_matrix_op.h"

/**
 * \ingroup inversion_3d_dpl
 * \typedef Inversion_3d_dpl_param
 *
 * \brief reference on inversion_3d_dpl_param structure
 *
 */
/**
 * \ingroup inversion_3d_dpl
 * \struct inversion_3d_dpl_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_inversion_3d_dpl_param
{
  int process; /*!< processing index */
  int confidence_type; /*!< confidence type (1: fwhm/curvature - 2: similarity peak) */
  float X_min; /*!< first coordonate in X to process */
  float Y_min; /*!< first coordonate in Y to process */
  float X_max; /*!< last coordonate in X to process */
  float Y_max; /*!< last  coordonate in Y to process */
  int nb; /*!< number of projections */
  float max_error; /*!< maximum threshold value to set */
  float min_error; /*!< minimum threshold value to set */
}inversion_3d_dpl_param, *Inversion_3d_dpl_param;

/**
 * \ingroup inversion_3d_dpl
 * \fn new_inversion_3d_dpl_param()
 *
 * \return A new reference on allocated inversion_3d_dpl_param structure
 *
 * \brief Create a new Inversion_3d_dpl_param reference 
 *
 */
static Inversion_3d_dpl_param new_inversion_3d_dpl_param();
/**
 * \ingroup inversion_3d_dpl
 * \fn free_inversion_3d_dpl_param(Inversion_3d_dpl_param p)
 *
 * \param p A reference on a inversion_3d_dpl_param structure
 *
 * \brief Free an allocated Inversion_3d_dpl_param reference 
 *
 */
void free_inversion_3d_dpl_param(Inversion_3d_dpl_param p);


/**
 * \ingroup inversion_3d_dpl
 * \fn void define_inversion_3d_dpl_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_inversion_3d_dpl_param(char *extra_description);

/**
 * \ingroup inversion_3d_dpl
 * \fn Inversion_3d_dpl_param get_inversion_3d_dpl_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Inversion_3d_dpl_param that contains the parameters.
 */
Inversion_3d_dpl_param get_inversion_3d_dpl_param();

/**
 * \ingroup inversion_3d_dpl
 * \fn void inversion_3d_dpl(Inversion_3d_dpl_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *u, EFIDIRImage *Sigmau);
 * \brief function of calculating the surface displacement from different projections
 * Function allowing to calculate the surface displacement in the frameword (E,N,U) from the displacements of different 
 * projections.
 *
 * \param p is the structure of the parameters for the operator 
 * \param def is the different projections of deformation
 * \param mask is the masks of different projections of deformation
 * \param error is the uncertainty image of different projections of deformation
 * \param u is the surface displacements in the framework (E, N, UP)
 * \param Sigmau is the strandard deviation of surface displacement
 * 
 */
void inversion_3d_dpl(Inversion_3d_dpl_param p, EFIDIRImage *def, EFIDIRImage *mask, EFIDIRImage *error, EFIDIRImage *u,  EFIDIRImage *Sigmau);

#endif //LAR_INVERSION_3D_DPL_H
