/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 
#ifndef COM_DIST_CORR_SERIES_H
#define COM_DIST_CORR_SERIES_H

#include "efidir_image.h"
#include "efidir_image_list.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include "lar_dist_corr.h"
#include <stdlib.h> 

/**
 * \ingroup serie
 * \defgroup dist_corr_series dist_corr_series an image
 */
/**
 * \ingroup dist_corr_series
 * \typedef Dist_corr_series_param
 * \author Flavien Vernier (LISTIC)
 *
 * \brief reference on dist_corr_series_param structure
 *
 */

/**
 * \ingroup dist_corr_series
 * \struct dist_corr_series_param
 *
 * \brief structure that contains the parameters of the operator dist_corr_series
 *
 */
 typedef struct struct_dist_corr_series_param{ 
   Dist_corr_param dist_corr_param; /*!< The dist_corr parameters for single image */
   int intercorrelationMode;    /*!< Intercorelation mode: 0 to correlate first image with the others;\n\t 1 (default value) to correlate image i and i+1;\n\tto correlate image i and i+2; and so on... */
 }dist_corr_series_param, *Dist_corr_series_param; 



/**
 * \ingroup dist_corr_series
 * \fn Dist_corr_series_param new_dist_corr_series_param()
 *
 * \return A new reference on allocated dist_corr_series_param structure
 *
 * \brief Create a new dist_corr_series_param reference 
 *
 */
Dist_corr_series_param new_dist_corr_series_param();
/**
 * \ingroup dist_corr_series
 * \fn free_dist_corr_series_param(Dist_corr_series_param p)
 *
 * \param p A reference on a dist_corr_series_param structure
 *
 * \brief Free an allocated dist_corr_series_param reference 
 *
 */
void free_dist_corr_series_param(Dist_corr_series_param p);

/**
 * \ingroup dist_corr_series
 * \fn void define_dist_corr_series_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of 
 * the same parameter (NULL is accepted)
*/
void define_dist_corr_series_param(char *extra_description);
/**
 * \ingroup dist_corr_series
 * \fn Dist_corr_series_param get_dist_corr_series_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A dist_corr_series_param that contains the parameters.
 */
Dist_corr_series_param get_dist_corr_series_param();

/**
 * \ingroup dist_corr_series
 * \fn void dist_corr_series(Dist_corr_series_param p, EFIDIRListImage inputImage, EFIDIRListImage outputImage);
 * \brief dist_corr_series an image
 * The dist_corr_series operator extracts a window given by a top left point and the size of the window.
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage Image to be dist_corr_seriesped. Image data can be not loaded.
 * \param outputImage is the image of result
 *
 */
void dist_corr_series(Dist_corr_series_param p, EFIDIRListImage inputImage, EFIDIRListImage outputImage);

#endif /* DIST_CORR_SERIES_H */
