/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup lardis_operators
 * \defgroup cumul_ml high speed uml sub-pixel displacement
 */
#ifndef COM_CUMUL_ML_H
#define COM_CUMUL_ML_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"


/**
 * \ingroup cumul_ml
 * \typedef Cumul_ml_param
 *
 * \brief reference on cumul_ml_param structure
 *
 */
/**
 * \ingroup cumul_ml
 * \struct cumul_ml_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */

typedef struct struct_cumul_ml_param{
  int window_search_nb_lines; /*!< line size of search window (azimut) */
  int window_search_nb_columns; /*!< column size of search window (range) */
  int window_patch_nb_lines; /*!< line size of process window (azimut) */
  int window_patch_nb_columns; /*!< column size of process window (range) */
  int mask_flag; /*!< used of mask (no:0 - yes:1)*/
}cumul_ml_param, *Cumul_ml_param;

/**
 * \ingroup cumul_ml
 * \fn new_cumul_ml_param()
 *
 * \return A new reference on allocated cumul_ml_param structure
 *
 * \brief Create a new cumul_ml_param reference 
 *
 */
static Cumul_ml_param new_cumul_ml_param();

/**
 * \ingroup cumul_ml
 * \fn free_cumul_ml_param(Cumul_ml_param p)
 *
 * \param p A reference on a cumul_ml_param structure
 *
 * \brief Free an allocated Cumul_ml_param reference 
 *
 */
void free_cumul_ml_param(Cumul_ml_param p);

/**
 * \ingroup cumul_ml
 * \fn void define_cumul_ml_param(char *extra_description)
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_cumul_ml_param(char *extra_description);

/**
 * \ingroup cumul_ml
 * \fn Cumul_ml_param get_cumul_ml_param()
 * \brief Default efidir function that gets parameters
 *
 * \return A Cumul_ml_param that contains the parameters.
 */
Cumul_ml_param get_cumul_ml_param();

/**
 * \ingroup cumul_ml
 * \fn void cumul_ml(Cumul_ml_param p,EFIDIRImage MasterImg,EFIDIRImage SlaveImg,EFIDIRImage MaskImg,EFIDIRImage DispImg,EFIDIRImage ValImg);
 * \brief function of sub-pixel displacement estimation by maximum likelihood texture tracking
 * Function a
 *
 * \param p is the structure of the parameters for the operator
 * \param MasterImg is the master image input
 * \param SlaveImg is the slave image input
 * \param MaskImg is the mask
 * \param DispImg is the displacement image 
 * \param ValImg is the similarity image
 *
 */
void cumul_ml(Cumul_ml_param p,EFIDIRImage MasterImg,EFIDIRImage SlaveImg,EFIDIRImage MaskImg,EFIDIRImage DispImg,EFIDIRImage ValImg);

#endif
 
