/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
 * \ingroup lardis_operators
 * \defgroup camera_dpl_measurement computing dispalcement image (in [cm/day]) in camera or DEM space  
 */
#ifndef LAR_CAMERA_DPL_MEASUREMENT_H
#define LAR_CAMERA_DPL_MEASUREMENT_H

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "efidir_image.h"
#include "efidir_param.h"
#include "efidir_string.h"
#include "efidir_image_list.h"
#include "lar_recal_image.h"
#include "lar_camera_dpl_measurement.h"
#include "lar_dem_camera_visu.h"
#include "lar_feasible_dpl_measurement_map.h"
/**
 * \ingroup camera_dpl_measurement
 * \typedef Camera_dpl_measurement_param
 *
 * \brief reference on camera_dpl_measurement_param structure
 *
 */
/**
 * \ingroup camera_dpl_measurement
 * \struct camera_dpl_measurement_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */

typedef struct struct_camera_dpl_measurement_param{
  int nb_lines_ascii; /*!< number of lines of registration/corrected displacement ascii files */
  int start_line_ascii; /*!< ascii strated line to pick used registration/corrected values */
  float threshold; /*!< threshold for selected feasible displacement measurement */
  int dpl_square_window; /*!< size of window used to compute displacement */
  float aperture_angle; /*!< aperture angle of camera [rad./pixel] */
  int verbose; /*!< Verbose option for debug*/ 
}camera_dpl_measurement_param, *Camera_dpl_measurement_param;

/**
 * \ingroup camera_dpl_measurement
 * \fn new_camera_dpl_measurement_param()
 *
 * \return A new reference on allocated camera_dpl_measurement_param structure
 *
 * \brief Create a new Camera_dpl_measurement_param reference 
 *
 */
static Camera_dpl_measurement_param new_camera_dpl_measurement_param();

/**
 * \ingroup camera_dpl_measurement
 * \fn free_camera_dpl_measurement_param(Camera_dpl_measurement_param p)
 *
 * \param p A reference on a camera_dpl_measurement_param structure
 *
 * \brief Free an allocated Camera_dpl_measurement_param reference 
 *
 */
void free_camera_dpl_measurement_param(Camera_dpl_measurement_param p);

/**
 * \ingroup camera_dpl_measurement
 * \fn void define_camera_dpl_measurement_param(char *extra_description)
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_camera_dpl_measurement_param(char *extra_description);

/**
 * \ingroup camera_dpl_measurement
 * \fn Camera_dpl_measurement_param get_camera_dpl_measurement_param()
 * \brief Default efidir function that gets parameters
 *
 * \return A Camera_dpl_measurement_param that contains the parameters.
 */
Camera_dpl_measurement_param get_camera_dpl_measurement_param();

/**
 * \ingroup camera_dpl_measurement
 * \fn void camera_dpl_measurement(Camera_dpl_measurement_param p,EFIDIRListImage peakImages,EFIDIRListImage vecImages,EFIDIRListImage fwhmImages,EFIDIRImage maskImage,EFIDIRImage distanceImage,EFIDIRImage eastImage,EFIDIRImage northImage,EFIDIRImage demImage,char *ascii_recal,char *ascii_correc,char *ascii_temporal_dist,EFIDIRImage dplxImage,EFIDIRImage dplyImage,EFIDIRImage fwhmxImage,EFIDIRImage fwhmyImage,EFIDIRImage peakImage,EFIDIRImage outputMaskImage,EFIDIRImage vecImage);
 * \brief function of image co-registration
 * Function allowing to mapped where the displacement measurement is possible
 *
 * \param p is the structure of the parameters for the operator
 * \param peakImages is the list peak images
 * \param vecImages is the list displacement vector images
 * \param fwhmImages is the list fwhm images
 * \param maskImage is ...
 * \param distanceImage is ...
 * \param eastImage is ...
 * \param northImage is ...
 * \param demImage is ...
 * \param ascii_recal is ...
 * \param ascii_correc is ...
 * \param ascii_temporal_dist is ...
 * \param dplxImage is ...
 * \param dplyImage is ...
 * \param fwhmxImage is ...
 * \param fwhmyImage is ...
 * \param peakImage is ...
 * \param outputMaskImage is ...
 * \param vecImage is ...
 *
 */
void camera_dpl_measurement(Camera_dpl_measurement_param p,EFIDIRListImage peakImages,EFIDIRListImage vecImages,EFIDIRListImage fwhmImages,EFIDIRImage maskImage,EFIDIRImage distanceImage,EFIDIRImage eastImage,EFIDIRImage northImage,EFIDIRImage demImage,char *ascii_recal,char *ascii_correc,char *ascii_temporal_dist,EFIDIRImage dplxImage,EFIDIRImage dplyImage,EFIDIRImage fwhmxImage,EFIDIRImage fwhmyImage,EFIDIRImage peakImage,EFIDIRImage outputMaskImage,EFIDIRImage vecImage);

#endif /* LAR_CAMERA_DPL_MEASUREMENT_H */
