/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef ERTEN_H
#define ERTEN_H

#include <stdlib.h>
#include <string.h>

#include <math.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_sf_hyperg.h>
#include <gsl/gsl_sf_psi.h>
#include <gsl/gsl_sf_gamma.h>
#include <gsl/gsl_sf_bessel.h>
#include <gsl/gsl_math.h>

#include "efidir_image.h"
#include "efidir_goodies.h"
#include "efidir_param.h"
#include "efidir_math.h"

typedef struct struct_erten_param{
 int area_x;
 int area_y;
 int x,y;
 int choix;
 
}erten_param, *Erten_param;

static Erten_param new_erten_param();
void free_erten_param(Erten_param p);

void define_erten_param(char *extra_description);

Erten_param get_erten_param();

void erten(Erten_param p, EFIDIRImage inputImage_master, EFIDIRImage inputImage_slave, EFIDIRImage outputImage, EFIDIRImage outputML, EFIDIRImage outputQ,EFIDIRImage masque,EFIDIRImage orientation);


#endif

