/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

#ifndef LAR_ML_T_H
#define LAR_ML_T_H

#include <stdlib.h>
#include <string.h>

#include <complex.h>
#include <math.h>
#include <gsl/gsl_sf_hyperg.h>
#include <gsl/gsl_sf_psi.h>
#include <gsl/gsl_sf_gamma.h>
#include <gsl/gsl_sf_bessel.h>
#include <gsl/gsl_math.h>


#include "efidir_image.h"
#include "efidir_goodies.h"
#include "efidir_param.h"

/**
 * \ingroup ML_tracking_matrix
 * \file lar_ML_tracking_matrix.h
 * \author Olivier Harant
 *
 * \brief operator of matrix manipulation for ML tracking
 *
 * file includes (stucture, prototype de fonction) of the operator ML_tracking
 *
 *
 */


/**
 * \ingroup ML_tracking_matrix
 * \typedef typedef ML_T_param
 *
 * \brief structure that contains the parameters of the operator ML_tracking_matrix
 *
 */


typedef struct struct_ml_t_param{
 int area_x;
 int area_y;
 int x,y;
 int choix;
 
}ml_t_param, *ML_T_param;


/**
 * \ingroup ML_tracking_matrix
 * \fn ML_T_param new_ml_t_param()
 *
 * \return A new reference on allocated ml_t_param structure
 *
 * \brief Create a new ML_T_param reference
 *
 */

static ML_T_param new_ml_t_param();


/**
 * \ingroup ML_tracking_matrix
 * \fn void free_ml_t_param(ML_T_param p);
 *
 * \param p A reference on a ml_t_param structure
 *
 * \brief Free an allocated ML_T_param reference
 *
 */


void free_ml_t_param(ML_T_param p);

/**
 * \ingroup ML_tracking_matrix
 * \fn void define_ml_t_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of
 * the same parameter (NULL is accepted)
*/

void define_ml_t_param(char *extra_description);


/**
 * \ingroup ML_tracking_matrix
 * \fn ML_T_param get_ml_t_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A ML_T_param that contains the parameters.
 */

ML_T_param get_ml_t_param();

/*void ml_t(ML_T_param p,
	   EFIDIRImage inputImage_master,
	   EFIDIRImage inputImage_slave,
	   EFIDIRImage outputImage1,
	   EFIDIRImage outputImage2,
	   EFIDIRImage outputImage3,
	   EFIDIRImage outputImage4,
	   EFIDIRImage output_img5,
	   EFIDIRImage output_img6,
	   EFIDIRImage output_img7,
	   EFIDIRImage output_img8,
	   EFIDIRImage output_img9,
	   EFIDIRImage output_img10,
	   EFIDIRImage output_img11,
	   EFIDIRImage output_img12,
	   EFIDIRImage masque,
	   EFIDIRImage orientation,
	   EFIDIRImage outputQML_F,
	   EFIDIRImage outputQML_Fb,
	   EFIDIRImage outputQML_G,
	   EFIDIRImage outputQML_Gb
	   );*/
void ml_t(ML_T_param p, EFIDIRImage inputImage_master, EFIDIRImage inputImage_slave, EFIDIRImage outputImage, EFIDIRImage masque,EFIDIRImage orientation);

void window_T(float **** image, float ***output, int i,int j,int a,int b);
void find_m(EFIDIRImage input, int *output, int H, int W);
float determinant_T3(float ***T);
float span_T3(float **** image, int i, int j);
EFIDIRImage determinant_T3_EFIDIR(EFIDIRImage T3);
EFIDIRImage read_T3_polsarpro(char *folder_in);

#endif

