/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup post_correlation
 * \defgroup truncation Reject displacement value according to its interval
 */
/**
 * \ingroup truncation
 * \file iff_truncation.h
 * \author Yajing Yan
 * 
 * \brief operator of generation of truncation
 * 
 * file includes (stucture, prototype de fonction) of the operator truncation
 * 
 * 
 */

#ifndef IFF_TRUNCATION_H
#define IFF_TRUNCATION_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"


/**
 * \ingroup truncation
 * \typedef Truncation_param
 *
 * \brief reference on truncation_param structure
 *
 */
/**
 * \ingroup truncation
 * \struct truncation_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_truncation_param{
  float valinf; /*!< min limit of interval */
  float valsup; /*!< max limit of interval */
}truncation_param, *Truncation_param;

/**
 * \ingroup truncation
 * \fn Truncation_param new_truncation_param()
 *
 * \return A new reference on allocated truncation_param structure
 *
 * \brief Create a new Truncation_param reference 
 *
 */
static Truncation_param new_truncation_param();
/**
 * \ingroup truncation
 * \fn void free_truncation_param(Truncation_param p)
 *
 * \param p A reference on a truncation_param structure
 *
 * \brief Free an allocated Truncation_param reference 
 *
 */
void free_truncation_param(Truncation_param p);


/**
 * \ingroup truncation
 * \fn void define_truncation_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_truncation_param(char *extra_description);

/**
 * \ingroup truncation
 * \fn Truncation_param get_truncation_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Truncation_param that contains the parameters.
 */
Truncation_param get_truncation_param();

/**
 * \ingroup truncation
 * \fn void truncation(Truncation_param p, EFIDIRImage inputDisp, EFIDIRImage inputMask, EFIDIRImage inputSigma, EFIDIRImage outputImage, EFIDIRImage outputMask);
 * \brief function of truncation of displacement value
 * Function allowing to truncate the displacement value according to its interval
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputDisp is the displacement image
 * \param inputMask is the displacement mask
 * \param inputSigma is the sigma image of displacement image
 * \param outputImage is the displacement image after truncation
 * \param outputMask is the mask of displacement image after truncation
 *
 */
void truncation(Truncation_param p, EFIDIRImage inputDisp, EFIDIRImage inputMask, EFIDIRImage inputSigma, EFIDIRImage outputImage, EFIDIRImage outputMask);


#endif
