/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup simple_mosaic Simple mosaic
 */
/**
 * \ingroup simple_mosaic
 * \file iff_simple_mosaic.h
 * \author Yajing Yan
 * 
 * \brief operator of simple_mosaic
 * 
 * file includes (stucture, prototype de fonction) of the operator simple_mosaic
 * 
 * 
 */

#ifndef IFF_SIMPLE_MOSAIC_H
#define IFF_SIMPLE_MOSAIC_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup simple_mosaic
 * \typedef Simple_mosaic_param
 *
 * \brief reference on simple_mosaic_param structure
 *
 */
/**
 * \ingroup simple_mosaic
 * \struct simple_mosaic_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_simple_mosaic_param{
  int index; /*!< index of processing */
  int r; /*!< number of rows of image to output */
  int c; /*!< number of columns of image to output */
}simple_mosaic_param, *Simple_mosaic_param;

/**
 * \ingroup simple_mosaic
 * \fn new_simple_mosaic_param()
 *
 * \return A new reference on allocated simple_mosaic_param structure
 *
 * \brief Create a new Simple_mosaic_param reference 
 *
 */
static Simple_mosaic_param new_simple_mosaic_param();
/**
 * \ingroup simple_mosaic
 * \fn free_simple_mosaic_param(Simple_mosaic_param p)
 *
 * \param p A reference on a simple_mosaic_param structure
 *
 * \brief Free an allocated Simple_mosaic_param reference 
 *
 */
void free_simple_mosaic_param(Simple_mosaic_param p);


/**
 * \ingroup simple_mosaic
 * \fn void define_simple_mosaic_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_simple_mosaic_param(char *extra_description);

/**
 * \ingroup simple_mosaic
 * \fn Simple_mosaic_param get_simple_mosaic_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Simple_mosaic_param that contains the parameters.
 */
Simple_mosaic_param get_simple_mosaic_param();

/**
 * \ingroup simple_mosaic
 * \fn void simple_mosaic(Simple_mosaic_param p, EFIDIRImage inputSeg1, EFIDIRImage inputSeg2, EFIDIRImage inputSeg3, EFIDIRImage inputSeg4, EFIDIRImage outputImage);
 * \brief function of generation of simple_mosaic
 * Function allowing to generate a simple_mosaic according to the value of image
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputSeg1 is the input image segment
 * \param inputSeg2 is the input image segment
 * \param inputSeg3 is the input image segment
 * \param inputSeg4 is the input image segment
 * \param outputImage is the output simple_mosaic
 *
 */
void simple_mosaic(Simple_mosaic_param p, EFIDIRImage inputSeg1, EFIDIRImage inputSeg2, EFIDIRImage inputSeg3, EFIDIRImage inputSeg4, EFIDIRImage outputImage);


#endif
