/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
*\ingroup post_correlation
*\defgroup sigma_to_confidence Convertion from standard deviation to confidence index
*/

/**
*\ingroup sigma_to_confidence
*\file iff_sigma_to_confidence.h
*\author Yajing Yan
*
*\brief operator of transformation of sigma to confidence
*
* file includes structures, prototypes of function of the operator sigma_to_confidence
*
*/

#ifndef IFF_SIGMA_TO_CONFIDENCE_H
#define IFF_SIGMA_TO_CONFIDENCE_H

#include<stdio.h>
#include<stdlib.h>
#include"efidir_image.h"
#include"efidir_param.h"

/**
*\ingroup sigma_to_confidence
* \fn void sigma_to_confidence(EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask, int method);
*\brief function de conversion from standard deviation to confidence 
* function that converts the standard deviation to the confidence
*
*\param inputImage is the image of standard deviation
*\param inputMask is the mask of the image of standard deviation
*\param outputImage is the image of confidence
*\param outputMask is the mask of the confidence
*\param method is the way of the conversion
*/

void sigma_to_confidence(EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage outputImage, EFIDIRImage outputMask, int method);

#endif 
