/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup model_inversion
 * \defgroup series_quadtree Quadtree Resampling on a series of images
 */
/**
 * \ingroup series_quadtree
 * \file iff_series_quadtree.h
 * \author Yajing Yan (LISTIC,LGIT)
 * 
 * \brief Quadtree resampling on a series of images
 * 
 * file includes (stucture, prototype de fonction) of the operator quatree
 * 
 * 
 */

#ifndef IFF_SERIES_QUADTREE_H
#define IFF_SERIES_QUADTREE_H

#include <stdio.h>
#include<stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"
#include "com_filter_median.h"
#include "iff_quadtree.h"

/**
 * \ingroup series_quadtree
 * \fn void series_quadtree(Quadtree_param p, EFIDIRImage *inputImage, EFIDIRImage *inputMask, EFIDIRImage *inputError, char **filename, int nb);
 * \brief function of quadtree resampling on a series of images
 * Function allowing to sub-resample a series of images according to certain criterion on the first image in the series
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the image series to resample
 * \param inputMask is the mask series of input image
 * \param inputError is the associated error image series 
 * \param filename is the output ASCII file series
 * \param nb is the number of images in the series
 *
 */

void series_quadtree(Quadtree_param p, EFIDIRImage *inputImage, EFIDIRImage *inputMask, EFIDIRImage *inputError, char **filename, int nb);

#endif
