/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup infos_fusion
 * \defgroup pre_fusion Visualisation of information for fusion
 */
/**
 * \ingroup pre_fusion
 * \file iff_pre_fusion.h
 * \author Yajing Yan (LISTIC,LGIT)
 * 
 * \brief operator of generation of an image for illustration of pre_fusion
 * 
 * file includes (stucture, prototype de fonction) of the operator pre_fusion
 * 
 * 
 */

#ifndef IFF_PRE_FUSION_H
#define IFF_PRE_FUSION_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"


/**
 * \ingroup pre_fusion
 * \typedef Pre_fusion_param
 *
 * \brief reference on pre_fusion_param structure
 *
 */
/**
 * \ingroup pre_fusion
 * \struct pre_fusion_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_pre_fusion_param{
  int index; /*!< 0: without fault trace 1: with fault trace */
  int nb; /*!< number of Tracks */
  float t1; /*!< threshold of correlation */
  float t2; /*!< threshold of interferometry */
  double lon_start; /*!< minimum value of longitude*/
  double lon_last; /*!< maximum value of longtitude */
  double lat_start; /*!< minimum value of latitude*/
  double lat_last; /*!< maximum value of latitude */
  float shiftX; /*!< shift in columns of fault position */
  float shiftY; /*!< shift in lines of fault position */
}pre_fusion_param, *Pre_fusion_param;

/**
 * \ingroup pre_fusion
 * \fn new_pre_fusion_param()
 *
 * \return A new reference on allocated pre_fusion_param structure
 *
 * \brief Create a new Pre_fusion_param reference
 *
 */
static Pre_fusion_param new_pre_fusion_param();
/**
 * \ingroup pre_fusion
 * \fn free_pre_fusion_param(Pre_fusion_param p)
 *
 * \param p A reference on a pre_fusion_param structure
 *
 * \brief Free an allocated Pre_fusion_param reference
 *
 */
void free_pre_fusion_param(Pre_fusion_param p);

/**
 * \ingroup pre_fusion
 * \fn void define_pre_fusion_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_pre_fusion_param(char *extra_description);

/**
 * \ingroup pre_fusion
 * \fn Pre_fusion_param get_pre_fusion_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Pre_fusion_param that contains the parameters.
 */
Pre_fusion_param get_pre_fusion_param();

/**
 * \ingroup pre_fusion
 * \fn void pre_fusion(Pre_fusion_param p, EFIDIRImage *def_series, EFIDIRImage *mask_series, EFIDIRImage *conf_series, char *fault_position, EFIDIRImage outputImage);
 * \brief function of generation of a 8 bits visualisation image for pre-fusion
 * Function allowing to generate an image for pre-fusion illustration
 *
 * \param p is the structure of the parameters for the operator
 * \param def_series is the deformation image series of different Tracks
 * \param mask_series is the mask series
 * \param conf_series is the confidence series
 * \param fault_position is the file containing the coordinates of the fault
 * \param outputImage is the image for illustration of pre_fusion de different Tracks
 *
 */
void pre_fusion(Pre_fusion_param p, EFIDIRImage *def_series, EFIDIRImage *mask_series, EFIDIRImage *conf_series, char *fault_position, EFIDIRImage outputImage);



#endif
