/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup interferometry
 * \defgroup pre_corr_alti2phi Pre-processing of altitude and phase correlation
 */
/**
 * \ingroup pre_corr_alti2phi
 * \file iff_pre_corr_alti2phi.h
 * \author Yajing Yan (LISTIC,LGIT)
 * 
 * \brief operator of generation of an image for illustration of pre_corr_alti2phi
 * 
 * file includes (stucture, prototype de fonction) of the operator pre_corr_alti2phi
 * 
 * 
 */

#ifndef IFF_PRE_CORR_ALTI2PHI_H
#define IFF_PRE_CORR_ALTI2PHI_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"


/**
 * \ingroup pre_corr_alti2phi
 * \typedef Pre_corr_alti2phi_param
 *
 * \brief reference on pre_corr_alti2phi_param structure
 *
 */
/**
 * \ingroup pre_corr_alti2phi
 * \struct pre_corr_alti2phi_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_pre_corr_alti2phi_param{
  int dx;/*!< shift in x  */
  int dy; /*!< shift in y*/
  int type; /*!< type of interleave */
}pre_corr_alti2phi_param, *Pre_corr_alti2phi_param;

/**
 * \ingroup pre_corr_alti2phi
 * \fn new_pre_corr_alti2phi_param()
 *
 * \return A new reference on allocated pre_corr_alti2phi_param structure
 *
 * \brief Create a new Pre_corr_alti2phi_param reference
 *
 */
static Pre_corr_alti2phi_param new_pre_corr_alti2phi_param();
/**
 * \ingroup pre_corr_alti2phi
 * \fn free_pre_corr_alti2phi_param(Pre_corr_alti2phi_param p)
 *
 * \param p A reference on a pre_corr_alti2phi_param structure
 *
 * \brief Free an allocated Pre_corr_alti2phi_param reference
 *
 */
void free_pre_corr_alti2phi_param(Pre_corr_alti2phi_param p);

/**
 * \ingroup pre_corr_alti2phi
 * \fn void define_pre_corr_alti2phi_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_pre_corr_alti2phi_param(char *extra_description);

/**
 * \ingroup pre_corr_alti2phi
 * \fn Pre_corr_alti2phi_param get_pre_corr_alti2phi_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Pre_corr_alti2phi_param that contains the parameters.
 */
Pre_corr_alti2phi_param get_pre_corr_alti2phi_param();

/**
 * \ingroup pre_corr_alti2phi
 * \fn void pre_corr_alti2phi(Pre_corr_alti2phi_param p, EFIDIRImage DemImage, EFIDIRImage DemMask, EFIDIRImage PhiImage, EFIDIRImage PhiMask, EFIDIRImage outputImage);
 * \brief function of pre-processing of correlation between altitude and phase
 * Function allowing to combine the phase image and DEM image, also their masks  and prepare for the visualisation of altitude and phase correlation sous ENVI
 *
 * \param p is the structure of the parameters for the operator
 * \param DemImage is the DEM
 * \param DemMask is the DEM mask
 * \param PhiImage is the phase image
 * \param PhiMask is the phase mask
 * \param outputImage is the image of combination
 *
 */

void pre_corr_alti2phi(Pre_corr_alti2phi_param p, EFIDIRImage DemImage, EFIDIRImage DemMask, EFIDIRImage PhiImage, EFIDIRImage PhiMask, EFIDIRImage outputImage);
#endif
