/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup interferometry
* \defgroup plot_phi_topo Plot phase value as a function of altitude
*/

/**
* \ingroup plot_phi_topo
* \file iff_plot_phi_topo.h
* \author Yajing Yan
*
* \brief operator of phase/topo plot
*
* file includes structures, prototypes of function of the operator plot_phi_topo
*
*/

#ifndef IFF_PLOT_PHI_TOPO_H
#define IFF_PLOT_PHI_TOPO_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_matrix_op.h"

/**
 * \ingroup plot_phi_topo
 * \typedef Plot_phi_topo_param
 *
 * \brief reference on plot_phi_topo_param structure
 *
 */

/**
 * \ingroup plot_phi_topo
 * \struct plot_phi_topo_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_plot_phi_topo_param{
  int xstart; /*!< first column of image to process */
  int ystart; /*!< first line of image to process */
  int nbx; /*!< number of columns of image to process */
  int nby; /*!< number of lines of image to process */
  int dx; /*!< offset in x of DEM with respect to image */
  int dy; /*!< offset in y of DEM with respect to image */
}plot_phi_topo_param, *Plot_phi_topo_param;

/**
 * \ingroup plot_phi_topo
 * \fn new_plot_phi_topo_param()
 *
 * \return A new reference on allocated plot_phi_topo_param structure
 *
 * \brief Create a new Plot_phi_topo_param reference 
 *
 */
static Plot_phi_topo_param new_plot_phi_topo_param();

/**
 * \ingroup plot_phi_topo
 * \fn free_plot_phi_topo_param(Plot_phi_topo_param p)
 *
 * \param p A reference on a plot_phi_topo_param structure
 *
 * \brief Free an allocated Plot_phi_topo_param reference 
 *
 */
void free_plot_phi_topo_param(Plot_phi_topo_param p);


/**
 * \ingroup plot_phi_topo
 * \fn void define_plot_phi_topo_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_plot_phi_topo_param(char *extra_description);

/**
 * \ingroup plot_phi_topo
 * \fn Plot_phi_topo_param get_plot_phi_topo_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Plot_phi_topo_param that contains the parameters.
 */
Plot_phi_topo_param get_plot_phi_topo_param();


/**
* \ingroup plot_phi_topo
* \fn void plot_phi_topo(Plot_phi_topo_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage inputDEM, char *inputfile, char *outputfile);
* \brief function of phase/topo plot
* function allowing to plot phase value as a function of altitude
*
* \param p is the structure of the parameters for the operator
* \param inputImage is the unwrapped interferogram
* \param inputMask is the mask of interferogram
* \param inputDEM is the DEM 
* \param inputfile is the file containing the window position
* \param outputfile is the file for plot
*
*/
void plot_phi_topo(Plot_phi_topo_param p, EFIDIRImage inputImage, EFIDIRImage inputMask, EFIDIRImage inputDEM, char *inputfile, char *outputfile);

#endif

