/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup interferometry
 * \defgroup phase_to_frequency Phase to frequency
 */

/**
 * \ingroup phase_to_frequency
 * \file iff_phase_to_frequency.h
 * \author Yajing Yan (LISTIC,LGIT)
 * 
 * \brief convert phase to local frequency
 * 
 * file includes (stucture, prototype de fonction) of the operator phase_to_frequency
 * 
 * 
 */

#ifndef IFF_PHASE_TO_FREQUENCY_H
#define IFF_PHASE_TO_FREQUENCY_H

#include <stdlib.h>
#include <string.h>
#include "efidir_image.h"
#include "efidir_param.h"



/**
 * \ingroup phase_to_frequency
 * \fn void phase_to_frequency(EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of convertion of phase to local frequency
 * Function allowing to convert phase to local frequency
 *
 * \param inputImage is the phase image
 * \param outputImage is the local frequency image
 *
 */
void phase_to_frequency(EFIDIRImage inputImage, EFIDIRImage outputImage);


#endif
