/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
*\ingroup post_correlation
*\defgroup mod_dir Calculate the magnitude and the direction of the deformation
*/

/**
*\ingroup mod_dir
*\file iff_mod_dir.h
*\author Yajing Yan
*
*\brief operator of calculating of the magnitude and the direction of deformation
*
*file includs structures, prototypes of function of the operator mod_dir
*
*/

#ifndef IFF_MOD_DIR_H
#define IFF_MOD_DIR_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"



/**
*\ingroup mod_dir
*\fn void mod_dir(EFIDIRImage inputDefx,EFIDIRImage inputMaskx,EFIDIRImage inputDefy,EFIDIRImage inputMasky,EFIDIRImage inputConfx,EFIDIRImage inputConfxMask,EFIDIRImage inputConfy,EFIDIRImage inputConfyMask,EFIDIRImage outputMod,EFIDIRImage outputDir,EFIDIRImage outputConf,EFIDIRImage outputMask);
*\brief function that displays an image from a ASCII file
*
*\param inputDefx is the deformation in range
*\param inputMaskx is tht mask of the deformation in range
*\param inputDefy is the deformation in azimuth
*\param inputMasky is the mask of the deformation in azimuth
*\param inputConfx is the confidence of deformation in range
*\param inputConfxMask is the mask of the confidence in range
*\param inputConfy is the confidence of deformation in azimuth
*\param inputConfyMask is the mask of confidence in azimuth
*\param outputMod is the image of amplitude of information
*\param outputDir is the image of direction of deformation
*\param outputConf is the image of confidence of the amplitude, the direction of deformation
*\param outputMask is the mask of the image
*
*/
void mod_dir(EFIDIRImage inputDefx,EFIDIRImage inputMaskx,EFIDIRImage inputDefy,EFIDIRImage inputMasky,EFIDIRImage inputConfx,EFIDIRImage inputConfxMask,EFIDIRImage inputConfy,EFIDIRImage inputConfyMask,EFIDIRImage outputMod,EFIDIRImage outputDir,EFIDIRImage outputConf,EFIDIRImage outputMask);

#endif
