/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup mask Generation of mask
 */
/**
 * \ingroup mask
 * \file iff_mask.h
 * \author Yajing Yan
 * 
 * \brief operator of generation of mask
 * 
 * file includes (stucture, prototype de fonction) of the operator mask
 * 
 * 
 */

#ifndef IFF_MASK_H
#define IFF_MASK_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup mask
 * \typedef Mask_param
 *
 * \brief reference on mask_param structure
 *
 */
/**
 * \ingroup mask
 * \struct mask_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_mask_param{
  int index; /*!< index of mask generation processing */
  float threshold; /*!< threshold for generation of mask */
}mask_param, *Mask_param;

/**
 * \ingroup mask
 * \fn Mask_param new_mask_param()
 *
 * \return A new reference on allocated mask_param structure
 *
 * \brief Create a new Mask_param reference 
 *
 */
static Mask_param new_mask_param();
/**
 * \ingroup mask
 * \fn void free_mask_param(Mask_param p)
 *
 * \param p A reference on a mask_param structure
 *
 * \brief Free an allocated Mask_param reference 
 *
 */
void free_mask_param(Mask_param p);


/**
 * \ingroup mask
 * \fn void define_mask_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_mask_param(char *extra_description);

/**
 * \ingroup mask
 * \fn Mask_param get_mask_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Mask_param that contains the parameters.
 */
Mask_param get_mask_param();

/**
 * \ingroup mask
 * \fn void mask(Mask_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);
 * \brief function of generation of mask
 * Function allowing to generate a mask according to the value of image
 *
 * \param p is the structure of the parameters for the operator 
 * \param inputImage is the input image
 * \param outputImage is the output mask
 *
 */
void mask(Mask_param p, EFIDIRImage inputImage, EFIDIRImage outputImage);


#endif
