/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup mapinfo Manipulation of map information
 */
/**
 * \ingroup mapinfo
 * \file iff_mapinfo.h
 * \author Yajing Yan
 * 
 * \brief operator of manipulation of map information
 * 
 * file includes (stucture, prototype de fonction) of the operator mapinfo
 * 
 * 
 */

#ifndef IFF_MAPINFO_H
#define IFF_MAPINFO_H

#include <stdio.h>
//#include <readline/readline.h>
//#include <readline/history.h>
#include <string.h>
#include "efidir_string.h"
#include "efidir_image.h"
#include "efidir_goodies.h"
#include "efidir_param.h"

/**
 * \ingroup mapinfo
 * \typedef Mapinfo_param
 *
 * \brief reference on mapinfo_param structure
 *
 */

/**
 * \ingroup mapinfo
 * \struct mapinfo_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_mapinfo_param{
  int nb; /*!< number of images to process */
}mapinfo_param, *Mapinfo_param;

/**
 * \ingroup mapinfo
 * \fn new_mapinfo_param()
 *
 * \return A new reference on allocated mapinfo_param structure
 *
 * \brief Create a new Mapinfo_param reference 
 *
 */
static Mapinfo_param new_mapinfo_param();
/**
 * \ingroup mapinfo
 * \fn free_mapinfo_param(Mapinfo_param p)
 *
 * \param p A reference on a mapinfo_param structure
 *
 * \brief Free an allocated Mapinfo_param reference 
 *
 */
void free_mapinfo_param(Mapinfo_param p);


/**
 * \ingroup mapinfo
 * \fn void define_mapinfo_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_mapinfo_param(char *extra_description);

/**
 * \ingroup mapinfo
 * \fn Mapinfo_param get_mapinfo_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Mapinfo_param that contains the parameters.
 */
Mapinfo_param get_mapinfo_param();


/**
 * \ingroup mapinfo
 * \fn void mapinfo(Mapinfo_param p, EFIDIRImage *series_images, char *mapinfofile);
 * \brief function of manipulation of map information
 * Function allowing to manipule map information
 *
 * \param p is the structure parameter of the operator
 * \param series_images is a series of images to process 
 * \param mapinfofile is the file including the size of the image to resize and the shifts in line and in column
 *
 */
void mapinfo(Mapinfo_param p, EFIDIRImage *series_images, char *mapinfofile);


#endif
