/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup 3D_inversion
 * \defgroup fuzzy_intersection Verify the intersection of fuzzy triangles of two series
 */
/**
 * \ingroup fuzzy_intersection
 * \file iff_fuzzy_intersection.h
 * \author Yajing Yan
 * 
 * \brief examination of intersection of fuzzy triangles of two series
 * 
 * file includes (stucture, prototype de fonction) of the operator fuzzy_intersection
 * 
 * 
 */

#ifndef IFF_FUZZY_INTERSECTION_H
#define IFF_FUZZY_INTERSECTION_H

#include <stdio.h>
#include<stdlib.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"


/**
 * \ingroup fuzzy_intersection
 * \typedef Fuzzy_intersection_param
 *
 * \brief reference on fuzzy_intersection_param structure
 *
 */
/**
 * \ingroup fuzzy_intersection
 * \struct fuzzy_intersection_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_fuzzy_intersection_param{
  int shiftx; /*!< offset of columns */
  int shifty;  /*!< offset of lines */
  int index; /*!< degree of intersection */
  int process; /*!< processing index */
}fuzzy_intersection_param, *Fuzzy_intersection_param;

/**
 * \ingroup fuzzy_intersection
 * \fn new_fuzzy_intersection_param()
 *
 * \return A new reference on allocated fuzzy_intersection_param structure
 *
 * \brief Create a new Fuzzy_intersection_param reference
 *
 */
static Fuzzy_intersection_param new_fuzzy_intersection_param();
/**
 * \ingroup fuzzy_intersection
 * \fn free_fuzzy_intersection_param(Fuzzy_intersection_param p)
 *
 * \param p A reference on a fuzzy_intersection_param structure
 *
 * \brief Free an allocated Fuzzy_intersection_param reference
 *
 */
void free_fuzzy_intersection_param(Fuzzy_intersection_param p);

/**
 * \ingroup fuzzy_intersection
 * \fn void define_fuzzy_intersection_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_fuzzy_intersection_param(char *extra_description);

/**
 * \ingroup fuzzy_intersection
 * \fn Fuzzy_intersection_param get_fuzzy_intersection_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Fuzzy_intersection_param that contains the parameters.
 */
Fuzzy_intersection_param get_fuzzy_intersection_param();

/**
 * \ingroup fuzzy_intersection
 * \fn void fuzzy_intersection(Fuzzy_intersection_param p, EFIDIRImage *inputImage, EFIDIRImage *inputError, EFIDIRImage outputImage);
 * \brief function of examination of intersection of fuzzy triangles of two series
 * Function allowing to verify the intersection of fuzzy triangles of two series
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the two center displacement image
 * \param inputError is the two interval images
 * \param outputImage is the binary image (0 - no intersection, 1 - intersection)
 *
 */

void fuzzy_intersection(Fuzzy_intersection_param p, EFIDIRImage *inputImage, EFIDIRImage *inputError, EFIDIRImage outputImage);


#endif
