/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup fuzzy_arth
 * \defgroup fuzzy_arithmetic Base fuzzy arithmetics
 */
/**
 * \ingroup fuzzy_arth
 * \file iff_fuzzy_arth.h
 * \author Yajing Yan 
 * 
 * \brief operator of fuzzy arithmetic
 * 
 * file includes (stucture, prototype de fonction) of the operator fuzzy_arth
 * 
 * 
 */

#ifndef IFF_FUZZY_ARTH_H
#define IFF_FUZZY_ARTH_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"

/**
 * \ingroup fuzzy_arth
 * \fn double* I_Produit_Cste (double val, double *vec, int dim);
 * \brief scalar product of a constant and a fuzzy interval
 *
 * \param val is the constant value
 * \param vec is the fuzzy interval
 * \param dim is the dimension of fuzzy interval matrix
 * \return a fuzzy interval
 */
double* I_Produit_Cste (double val, double *vec, int dim);


/**
 * \ingroup fuzzy_arth
 * \fn double* I_plus (double *vec1, double *vec2, int dim);
 * \brief sum of 2 fuzzy intervals
 * Function allowing to calculate the sum of 2 fuzzy intervals with triangle distribution in format of (KA-SA, KA, KA+SA)
 *
 * \param vec1 is the first fuzzy interval
 * \param vec2 is the second fuzzy interval
 * \param dim is the dimension of fuzzy interval matrix
 * \return a fuzzy interval
 */
double* I_plus (double *vec1, double *vec2, int dim);


/**
 * \ingroup fuzzy_arth
 * \fn double** I_produit_matriciel (double **A, double **X, int col);
 * \brief product of a scalar matrix and a fuzzy vector
 * Function allowing to calculate the product of a scalar matrix A and a fuzzy vector X: Y= AX
 *
 * \param A is the scalar matrix (3 lines) 
 * \param X is the fuzzy vector
 * \param col is the column of matrix A 
 * \return a fuzzy vector 
 */
double** I_produit_matriciel (double **A, double **X, int col);


#endif
