/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup infos_fusion
 * \defgroup fusion_mask Masks fusion
 */
/**
 * \ingroup fusion_mask
 * \file iff_fusion_mask.h
 * \author Yajing Yan
 * 
 * \brief operator of fusion of masks
 * 
 * file includes (stucture, prototype de fonction) of the operator fusion_mask
 * 
 * 
 */

#ifndef IFF_FUSION_MASK_H
#define IFF_FUSION_MASK_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"


/**
 * \ingroup fusion_mask
 * \fn void fusion_mask(EFIDIRImage *series_mask, int number, EFIDIRImage output_mask);
 * \brief function of masks fusion
 * Function allowing to merge several masks into one 
 *
 * \param series_mask is the mask series
 * \param number is the number of images in the series
 * \param output_mask is the mask after fusion
 *
 */
void fusion_mask(EFIDIRImage *series_mask, int number, EFIDIRImage output_mask);


#endif
