/* 
 *    Copyright (c) 2008. The EFIDIR team. All right reserved. 
 * 
 *    This file is part of EFIDIR tools. 
 * 
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify 
 *    it under the terms of the GNU General Public License as published by 
 *    the Free Software Foundation, either version 3 of the License, or 
 *    (at your option) any later version. 
 * 
 *    EFIDIR tool(s) is distributed in the hope that it will be useful, 
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *    GNU General Public License for more details. 
 * 
 *    You should have received a copy of the GNU General Public licence 
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>. 
 */ 

/**
* \ingroup post_correlation
* \defgroup file_image formation of image of a particular parameter from an ASCII file
*/

/**
* \ingroup file_image
* \file iff_file_image.h
* \author Yajing Yan
*
* \brief operator of formation of image from a ASCII file
*
* file includes structures,prototypes of function of the operator file_image
*
*/

#ifndef IFF_FILE_IMAGE_H
#define IFF_FILE_IMAGE_H

#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<string.h>
#include"efidir_image.h"
#include"efidir_param.h"
#include"efidir_assert.h"

/**
* \ingroup file_image
* \typedef typedef File_image_param
*
* \brief structure that contains the parameters of the operator
*
*/
typedef struct struct_file_image_param
{
  int EFIDIR_Rlooks;/*range looks*/
  int EFIDIR_Alooks;/*azimuth looks*/
  int X_start;/*beginning of column*/
  int Y_start;/*beginning of row*/
  int r;/*number of lines of the image to display*/
  int c;/*number of rows of the image to display*/
  int pos_x;/*position of columns in the ASCII file*/
  int pos_y;/*position of rows in the ASCII file*/
  int pos_param;/*position of parameter to display in the ASCII file*/
  double gain;/*gain of parameters in the file*/
}file_image_param,*File_image_param;

/**
 * \ingroup file_image
 * \fn File_image_param new_file_image_param();
 *
 * \return A new reference on allocated file_image_param structure
 *
 * \brief Create a new File_image_param reference
 *
 */

static File_image_param new_file_image_param();

/**
 * \ingroup file_image
 * \fn void free_file_image_param(File_image_param p);
 *
 * \param p A reference on a file_image_param structure
 *
 * \brief Free an allocated File_image_param reference
 *
 */

void free_file_image_param(File_image_param p);

/**
* \ingroup file_image
* \fn void define_file_image_param(char *extra_description);
* \brief Default edifir function that defines parameters
*
* \param extra_description Extra description for multi definition of the same parameter(NULL is accepted)
*
*/
 void define_file_image_param(char *extra_description);

/**
* \ingroup file_image
* \fn File_image_param get_file_image_param();
* \brief Default edifir function that gets parameters
*
* \return A File_image_param that contains the parameters
*
*/
File_image_param get_file_image_param();


/**
 * \ingroup file_image
 * \fn void file_image(File_image_param p, char *file_name, EFIDIRImage outputImage, EFIDIRImage outputMask);
 * \brief function that displays an image from a ASCII file
 *
 * \param p operator parameters
 * \param file_name name is the name of the ASCII file
 * \param outputImage is the image to display
 * \param outputMask is the mask of the image
 *
 */
void file_image(File_image_param p, char *file_name, EFIDIRImage outputImage, EFIDIRImage outputMask);

#endif
