/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup divers
 * \defgroup fault_location Fault location on displacement image
 */
/**
 * \ingroup fault_location
 * \file iff_fault_location.h
 * \author Yajing Yan (LISTIC,LGIT)
 * 
 * \brief operator of generation of an image for illustration of fault_location
 * 
 * file includes (stucture, prototype de fonction) of the operator fault_location
 * 
 * 
 */

#ifndef IFF_FAULT_LOCATION_H
#define IFF_FAULT_LOCATION_H

#include <stdio.h>
#include "efidir_image.h"
#include "efidir_param.h"

#include "efidir_string.h"
#include "com_convert_datatype.h"


/**
 * \ingroup fault_location
 * \typedef Fault_location_param
 *
 * \brief reference on fault_location_param structure
 *
 */
/**
 * \ingroup fault_location
 * \struct fault_location_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_fault_location_param{
float shiftX; /*!< shift in columns of fault position */
float shiftY; /*!< shift in lines of fault position */
}fault_location_param, *Fault_location_param;

/**
 * \ingroup fault_location
 * \fn new_fault_location_param()
 *
 * \return A new reference on allocated fault_location_param structure
 *
 * \brief Create a new Fault_location_param reference
 *
 */
static Fault_location_param new_fault_location_param();
/**
 * \ingroup fault_location
 * \fn free_fault_location_param(Fault_location_param p)
 *
 * \param p A reference on a fault_location_param structure
 *
 * \brief Free an allocated Fault_location_param reference
 *
 */
void free_fault_location_param(Fault_location_param p);

/**
 * \ingroup fault_location
 * \fn void define_fault_location_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_fault_location_param(char *extra_description);

/**
 * \ingroup fault_location
 * \fn Fault_location_param get_fault_location_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Fault_location_param that contains the parameters.
 */
Fault_location_param get_fault_location_param();

/**
 * \ingroup fault_location
 * \fn void fault_location(Fault_location_param p, EFIDIRImage inputImage, char *fault_position, char *color_map, EFIDIRImage outputImage);
 * \brief function of generation of a 8 bits image with fault location
 * Function allowing to locatate the fault in a displacement image
 *
 * \param p is the structure of the parameters for the operator
 * \param inputImage is the displacement image
 * \param fault_position is the file containing the coordinates of the fault
 * \param color_map is the color look up table
 * \param outputImage is the image with fault location
 *
 */
void fault_location(Fault_location_param p, EFIDIRImage inputImage, char *fault_position, char *color_map, EFIDIRImage outputImage);



#endif
