/*
 *    Copyright (c) 2008. The EFIDIR team. All right reserved.
 *
 *    This file is part of EFIDIR tools.
 *
 *    EFIDIR tool(s) is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    EFIDIR tool(s) is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public licence
 *    along with EFIDIR tools.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \ingroup projection
 * \defgroup dim_trans Projection of 3D image into 2D
 */
/**
 * \ingroup dim_trans
 * \file iff_dim_trans.h
 * \author Yajing Yan
 * 
 * \brief operator of projection of 3D (E,N,Up) image in 2D (range, azimuth)
 * 
 * file includes (stucture, prototype de fonction) of the operator dim_trans
 * 
 * 
 */

#ifndef IFF_DIM_TRANS_H
#define IFF_DIM_TRANS_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "efidir_image.h"
#include "efidir_param.h"

/**
 * \ingroup dim_trans
 * \typedef Dim_trans_param
 *
 * \brief reference on dim_trans_param structure
 *
 */
/**
 * \ingroup dim_trans
 * \struct dim_trans_param
 *
 * \brief structure that contains the parameters of the operator
 *
 */
typedef struct struct_dim_trans_param{
  int rfirst; /*!< first line to compute */
  int rlast; /*!< last line to compute */
  int cfirst; /*!< first column to compute */
  int clast; /*!< last column to compute */
  double *vect_Rg; /*!< range projection vector */
}dim_trans_param, *Dim_trans_param;

/**
 * \ingroup dim_trans
 * \fn new_dim_trans_param()
 *
 * \return A new reference on allocated dim_trans_param structure
 *
 * \brief Create a new Dim_trans_param reference 
 *
 */
static Dim_trans_param new_dim_trans_param();
/**
 * \ingroup dim_trans
 * \fn free_dim_trans_param(Dim_trans_param p)
 *
 * \param p A reference on a dim_trans_param structure
 *
 * \brief Free an allocated Dim_trans_param reference 
 *
 */
void free_dim_trans_param(Dim_trans_param p);


/**
 * \ingroup dim_trans
 * \fn void define_dim_trans_param(char *extra_description);
 * \brief Default efidir function that defines parameters
 *
 * \param extra_description Extra description for multi definition of the same parameter (NULL is accepted)
 */
void define_dim_trans_param(char *extra_description);

/**
 * \ingroup dim_trans
 * \fn Dim_trans_param get_dim_trans_param();
 * \brief Default efidir function that gets parameters
 *
 * \return A Dim_trans_param that contains the parameters.
 */
Dim_trans_param get_dim_trans_param();

/**
 * \ingroup dim_trans
 * \fn void dim_trans(Dim_trans_param p, EFIDIRImage CompE, EFIDIRImage CompN, EFIDIRImage CompUp, EFIDIRImage ImageRg);
 * \brief function of projection of 3D (E,N,Up) image in 2D 
 * Function allowing to transform the 3D image in 2D with the projection vectors
 *
 * \param p is the structure of the parameters for the operator 
 * \param CompE is the E component image (input)
 * \param CompN is the N component image (input)
 * \param CompUp is the Up component image (input) 
 * \param ImageRg is the Range component image (output)
 *
 */
void dim_trans(Dim_trans_param p, EFIDIRImage CompE, EFIDIRImage CompN, EFIDIRImage CompUp, EFIDIRImage ImageRg);


#endif
